#!/bin/ash

if [ $# -le 0 -o $# -ge 2 ]; then
  echo Incorrect amount of arguments
  exit 1
fi

VERIZONWRONG=0
ATTWRONG=0

LOCKFILE=/tmp/changingproviders

while [ -f $LOCKFILE ] ; do
 sleep 1
done

touch $LOCKFILE

VERIZONUSB=`cat /proc/tty/driver/usbserial | grep product:0028 | head -n 1 | cut -d : -f 1`
ATTUSB=`cat /proc/tty/driver/usbserial | grep product:683c | head -n 4 | tail -n 1 | cut -d : -f 1`

# If a modem is disconnected or the driver didn't load/init then default to ttyUSB7
#  because ttyUSB7 is where the AT-command port will show up for any modem enumerated second
if [ "$VERIZONUSB" == "" ] ; then VERIZONUSB=7 ; fi
if [ "$ATTUSB" == "" ] ; then ATTUSB=7; fi

VERIZONUSB=ttyUSB$VERIZONUSB
ATTUSB=ttyUSB$ATTUSB

grep $VERIZONUSB /etc/config/network.verizon 1>/dev/null 2>/dev/null || VERIZONWRONG=1
grep $ATTUSB /etc/config/network.att 1>/dev/null 2>/dev/null || ATTWRONG=1

sed -i 's/ttyUSB[0-9]*/'$ATTUSB'/' /etc/config/network.att
sed -i 's/ttyUSB[0-9]*/'$VERIZONUSB'/' /etc/config/network.verizon

# If they are both wrong then AT&T wins because it's checked second
if [ "$1" == "verizon" -o "$ATTWRONG" == "1" ]; then
  # If something is wrong with AT&T then we prefer Verizon
  ln -sf /etc/config/network.verizon /etc/config/network
  logger -t providerchange.sh "SWITCHING 3G PROVIDER TO VERIZON on $VERIZONUSB"
fi
if [ "$1" == "att" -o "$VERIZONWRONG" == "1" ]; then
  # If something is wrong with Verizon then we prefer AT&T
  ln -sf /etc/config/network.att /etc/config/network
  logger -t providerchange.sh "SWITCHING 3G PROVIDER TO AT&T on $ATTUSB"
fi

if [ "$VERIZONWRONG" == "0" -a "$ATTWRONG" == "0" -a "$1" == "verify" ] ; then
 # Nothing to see here, all is correct, do nothing further
 rm -f $LOCKFILE
 exit 0
fi

logger -t providerchange.sh "RESTARTING 3G NETWORK"

ifdown 3G 1>/dev/null 2>/dev/null
sleep 2
ifup 3G 1>/dev/null 2>/dev/null

# If we down the 3G connection we shouldn't rerun this script while it's trying to
#  redial, so give it a minute to try to connect.  This sleep 60 is just a guess at
#  the timing required for this to be reliable.
sleep 30
/etc/init.d/openvpn restart 1>/dev/null 2>/dev/null

rm -f $LOCKFILE

exit 0
