#!/usr/bin/php-cgi
<?php

#### Aquires Verizon RSSI value and strings used by bandwidth.cgi
$verizonoutput = file("/tmp/verizonmetrics");
$verizonrssi = explode("\n", $verizonoutput[0]);
$verizonroaming = explode("\n", $verizonoutput[1]);

#### Aquires AT&T RSSI value and strings used by bandwidth.cgi
$attOutput = file('/tmp/attmetrics');
$attrssi = explode("\n", $attOutput[0]);
$attroaming = explode("\n", $attOutput[1]);

#### Aquires VPN status and IP
$vpnstatus = "Inactive";
if (shell_exec("ifconfig tap0")) {
  $vpnstatus = "Active";
  $tap0ip = shell_exec("ifconfig tap0 | grep -i inet | cut -d : -f 2 | cut -d ' ' -f 1");
}

#### Aquires bucket usage
$bucketusage = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 1");
$bucketprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 2");
if (preg_match ( "/MiB/", $bucketprefix)) {
  if ($bucketusage <= 1024) {
    $buckettotalusage = $bucketusage / 1024;
  }
  else {
    $buckettotalusage = 1;
  }
}
else if (preg_match ( "/GiB/", $bucketprefix)) {
  if ($bucketusage <= 1) {
    $buckettotalusage = $bucketusage;
  }
  else {
    $buckettotalusage = 1;
  }
}
else if (preg_match ( "/KiB/", $bucketprefix)) {
  $buckettotalusage = $bucketusage / 1048576;
}
else {
  $buckettotalusage = 0;
}

#### Aquires the current provider
$output = shell_exec("ls -la /etc/config/network | cut -d . -f 2");

if (preg_match("/verizon/", $output)) {
  $currentprovider = "Verizon";
}
else if (preg_match("/att/", $output)) {
  $currentprovider = "AT&T";
}

#### Aquires 3g uptime
$sysuptime = shell_exec("cat /proc/uptime | cut -d ' ' -f 1 | cut -d . -f 1");
$carduptime = shell_exec("uci -P/var/state show network.3G | grep time | cut -d = -f 2");
$currentuptime = $sysuptime - $carduptime;

#### Aquires current bandwidth speed cap
$filename = "/tmp/.slowmedown";
$slowwaydown = "/tmp/.whoaNelly";
$speedcap = "N/A";

if (file_exists($filename)) {
   $speedcap = 100;
}
else if (file_exists($slowwaydown)) {
   $speedcap = 10;
}


$parameters = array(
	"ping"=>42,
	"bucket" => $buckettotalusage,
	"connectionTime" => $currentuptime,
	"ip" => $tap0ip,
	"vpnStatus" => $vpnstatus,
	"currentProvider" => $currentprovider,
	"speedCap" => $speedcap,
	"cards" => array (
		array("provider" => "AT&T", "rssi" => "$attrssi[0]"),
		array("provider" => "Verizon", "rssi" => $verizonrssi[0])
	)
);

echo json_encode($parameters);
?>
