#!/bin/ash

if [ $# -le 0 -o $# -ge 2 ]; then
  echo Incorrect amount of arguments
  echo "Usage: $0 [verizon|att|verify]"
  exit 1
fi

if [ "$1" != "verizon" -a "$1" != "att" -a "$1" != "verify" ] ; then
  echo "Usage: $0 [verizon|att|verify]"
  exit 1
fi

VERIZONWRONG=0
ATTWRONG=0

LOCKFILE=/tmp/changingproviders

# This runs every minute, so this script shouldn't wait longer than a minute for the lockfile
n=0
while [ -f $LOCKFILE ] ; do
 sleep 1
 let n+=1
 #echo $n
 if [ $n -gt 50 ] ; then
   exit 1
 fi
done

touch $LOCKFILE

VERIZONUSB=`cat /proc/tty/driver/usbserial | grep product:0028 | head -n 1 | cut -d : -f 1`
ATTUSB=`cat /proc/tty/driver/usbserial | grep product:683c | head -n 4 | tail -n 1 | cut -d : -f 1`

NOVERIZON=false
NOATT=false

# Preserve the existing state for use later
/usr/bin/isverizon && VERIZON=true || VERIZON=false

# If a modem is disconnected or the driver didn't load/init then default to ttyUSB7
#  because ttyUSB7 is where the AT-command port will show up for any modem enumerated second
if [ "$VERIZONUSB" == "" ] ; then VERIZONUSB=7 ; NOVERIZON=true ; fi
if [ "$ATTUSB" == "" ] ; then ATTUSB=7; NOATT=true ; fi

VERIZONUSB=ttyUSB$VERIZONUSB
ATTUSB=ttyUSB$ATTUSB

grep $VERIZONUSB /etc/config/network.verizon 1>/dev/null 2>/dev/null || VERIZONWRONG=1
grep $ATTUSB /etc/config/network.att 1>/dev/null 2>/dev/null || ATTWRONG=1

sed -i 's/ttyUSB[0-9]*/'$ATTUSB'/' /etc/config/network.att
sed -i 's/ttyUSB[0-9]*/'$VERIZONUSB'/' /etc/config/network.verizon

# If they are both wrong then AT&T wins because it's checked second
if [ "$1" == "verizon" -o "$ATTWRONG" == "1" ]; then
  # If something is wrong with AT&T then we prefer Verizon
 if [ "$NOVERIZON" == "false" ] ; then
  ln -sf /etc/config/network.verizon /etc/config/network
  logger -t providerchange.sh "REQUESTED TO SWITCH 3G PROVIDER TO VERIZON on $VERIZONUSB"
 else
  logger -t providerchange.sh "NO VERIZON MODEM CONNECTED - NOT SWITCHING 3G PROVIDER TO VERIZON on $VERIZONUSB"
 fi
fi

if [ "$1" == "att" -o "$VERIZONWRONG" == "1" ]; then
  # If something is wrong with Verizon then we prefer AT&T
 if [ "$NOATT" == "false" ] ; then
   ln -sf /etc/config/network.att /etc/config/network
   logger -t providerchange.sh "REQUESTED TO SWITCH 3G PROVIDER TO AT&T on $ATTUSB"
 else
   logger -t providerchange.sh "NO AT&T MODEM CONNECTED - NOT SWITCHING 3G PROVIDER TO AT&T on $ATTUSB"
 fi
fi

if [ "$1" == "att" -a "$NOATT" == "true" ]; then
 logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - AT&T REQUESTED BUT NO AT&T MODEM PRESENT"
 rm -f $LOCKFILE
 exit 1
fi

if [ "$1" == "verizon" -a "$NOVERIZON" == "true" ]; then
 logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - VERIZON REQUESTED BUT NO VERIZON MODEM PRESENT"
 rm -f $LOCKFILE
 exit 1
fi

if [ "$VERIZON" == "true" ] ; then
 if [ "$VERIZONWRONG" == "0" -a "$1" == "verify" ] ; then
  # Nothing to see here, all is correct, already on verizon, do nothing further
  #logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - VERIZON OK"
  rm -f $LOCKFILE
  exit 0
 fi
fi


if [ "$VERIZON" == "false" ] ; then
 if [ "$ATTWRONG" == "0" -a "$1" == "verify" ] ; then
  # Nothing to see here, all is correct, already on AT&T, do nothing further
  #logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - AT&T OK"
  rm -f $LOCKFILE
  exit 0
 fi
fi

if [ "$VERIZON" == "true" -a "$VERIZONWRONG" == "0" -a "$1" == "verizon" ] ; then
  logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - ALREADY ON VERIZON"
  rm -f $LOCKFILE
  exit 0
fi

if [ "$VERIZON" == "false" -a "$ATTWRONG" == "0" -a "$1" == "att" ] ; then
  logger -t providerchange.sh "NOT RESTARTING 3G NETWORK - ALREADY ON AT&T"
  rm -f $LOCKFILE
  exit 0
fi


# OK Wow if we get to this point then something was changed or requested to be changed
#  and it was not already in the requested state, so we have to restart 3G to effect
#  the change

logger -t providerchange.sh "RESTARTING 3G NETWORK"

ifdown 3G 1>/dev/null 2>/dev/null
sleep 2
ifup 3G 1>/dev/null 2>/dev/null

# If we down the 3G connection we shouldn't rerun this script while it's trying to
#  redial, so give it a minute to try to connect.  This sleep 60 is just a guess at
#  the timing required for this to be reliable.
sleep 30
/etc/init.d/openvpn restart 1>/dev/null 2>/dev/null

rm -f $LOCKFILE
exit 0
