#!/bin/bash

# The purpose of this program is to ping our test hosts and then report network status.
#	The test hosts IPs are in /etc/testserver[123]
#
# The network status/health has 3 parts:
#	RTT average time (ms)
#	Standard deviation (ms) should be less than 20% of RTT
#	Packet loss should be 0% at the 64 byte ping packet size
#	We could estimate bandwidth to our test hosts
#
# This script will write out /tmp/pingcheck.txt as follows:
# reachable, rtt, mdev, loss
#
# ASSUMPTION: integer math is good enough.


OUTPUT=/tmp/pingcheck.txt
rm -f $OUTPUT

for testserver in 1 2 3  ; do
 ping -q -c 4 -W 4 `cat /etc/testserver$testserver` > /tmp/ping$testserver 2>/dev/null
done

# This looks stupid but I couldn't get sub-variable names to work right in bash.
#  i.e. $RTT$NUMBER throws an error, whereas $RTT1 works fine.  This just makes for more
#  typing & lines of code to accomplish the task.

RTT1=NULL
RTT2=NULL
RTT3=NULL
MDEV1=NULL
MDEV2=NULL
MDEV3=NULL
LOSS1=100
LOSS2=100
LOSS3=100

grep rtt /tmp/ping1 1>/dev/null 2>/dev/null && {
 RTT1=`grep rtt /tmp/ping1 | awk -F/ '{print $6}' | awk -F. '{print $1}'`
 MDEV1=`grep rtt /tmp/ping1 | awk -F/ '{print $7}' | awk '{print $1}' | awk -F. '{print $1}'`
}

grep loss /tmp/ping1 1>/dev/null 2>/dev/null && {
 LOSS1=`grep loss /tmp/ping1 | awk -F, '{print $3}' | awk '{print $1}' | awk -F% '{print $1}'`
}

grep rtt /tmp/ping2 1>/dev/null 2>/dev/null && {
 RTT2=`grep rtt /tmp/ping2 | awk -F/ '{print $6}' | awk -F. '{print $1}'`
 MDEV2=`grep rtt /tmp/ping2 | awk -F/ '{print $7}' | awk '{print $1}' | awk -F. '{print $1}'`
}

grep loss /tmp/ping2 1>/dev/null 2>/dev/null && {
 LOSS2=`grep loss /tmp/ping2 | awk -F, '{print $3}' | awk '{print $1}' | awk -F% '{print $1}'`
}

grep rtt /tmp/ping3 1>/dev/null 2>/dev/null && {
 RTT3=`grep rtt /tmp/ping3 | awk -F/ '{print $6}' | awk -F. '{print $1}'`
 MDEV3=`grep rtt /tmp/ping3 | awk -F/ '{print $7}' | awk '{print $1}' | awk -F. '{print $1}'`
}

grep loss /tmp/ping3 1>/dev/null 2>/dev/null && {
 LOSS3=`grep loss /tmp/ping3 | awk -F, '{print $3}' | awk '{print $1}' | awk -F% '{print $1}'`
}

RTT=0
MDEV=0
REACHABLE=0
LOSS=0

if [ "$RTT1" == "NULL" ] && [ "$RTT2" == "NULL" ] && [ "$RTT3" == "NULL" ] ; then
 # 0 reachable, 0ms rtt, 0ms mdev, 100% packet loss
 echo "0 0 0 100" > $OUTPUT
 #echo I HAZ NO INTERNETZ. Exiting...
 exit 1
fi

if [ "$RTT1" != "NULL" ] ; then
 let REACHABLE+=1
 let RTT+=$RTT1
 let MDEV+=$MDEV1
 let LOSS+=$LOSS1
fi

if [ "$RTT2" != "NULL" ] ; then
 let REACHABLE+=1
 let RTT+=$RTT2
 let MDEV+=$MDEV2
 let LOSS+=$LOSS2
fi

if [ "$RTT3" != "NULL" ] ; then
 let REACHABLE+=1
 let RTT+=$RTT3
 let MDEV+=$MDEV3
 let LOSS+=$LOSS3
fi

# Use only the number of reachable hosts in calculating averages.
let AVGRTT=$RTT/$REACHABLE
let AVGMDEV=$MDEV/$REACHABLE
let AVGLOSS=$LOSS/$REACHABLE

#echo $RTT $REACHABLE $AVGRTT
#echo $MDEV $REACHABLE $AVGMDEV

echo "$REACHABLE $AVGRTT $AVGMDEV $AVGLOSS" > $OUTPUT

# The determination of what's a squirrely network will have to be done in a user-facing application
#  like bandwidth.cgi
#let SQUIRRELY=$AVGRTT/$AVGMDEV
#echo $SQUIRRELY
#if [ "$SQUIRRELY" -lt "4" ] ; then
#  echo Network is SQUIRRELY: ratio of sigma to rtt is 33% or greater
#fi
