#!/usr/bin/php-cgi
<?php

#### Aquires Verizon RSSI value and strings used by bandwidth.cgi
$verizonrssi = shell_exec("mmcli -m 18 | grep signal | cut -d \" \" -f 15 | sed s/\'//g");
$verizonroaming = shell_exec("mmcli -m 18 | grep -i registration | cut -d \" \" -f 16 | sed s/\'//g | tr -d '\n' ");

#### Aquires AT&T RSSI value and strings used by bandwidth.cgi
$attOutput = file('/tmp/attmetrics');
$attrssi = explode("\n", $attOutput[0]);
$attroaming = explode("\n", $attOutput[1]);

#### Aquires ping information from /tmp/pingcheck.txt
if (file_exists('/tmp/pingcheck.txt')) {
$pingOutput = file('/tmp/pingcheck.txt');
$pingMetrics = explode(" ", $pingOutput[0]);
}

#### Aquires the current provider
$currentprovider = trim(shell_exec("ls -la /etc/config/network | cut -d . -f 2"));

#### Gather connection status
system("ifconfig ppp0 | grep -i inet 1>/dev/null 2>/dev/null", $retval);

if ( $retval == "0" ) {
   $connection3g = 1;
   system("netstat -rn | grep ^0.0.0.0 | grep -i 3G 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     $internetstatus = 1;
   }
   else {
     $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
     if ( $retval == "0" ) {
       $internetstatus = 2;
     }
     else {
       $internetstatus = 0;
     }
   }
   $redialing = -1;
   $connectionmetrics = shell_exec("ifconfig ppp0 | grep -i inet");
}
else
{
   $connection3g = 0;
   system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     $internetstatus = 2;
   }
   else {
   $internetstatus = -1;
   }
   system("logread | grep pppd  1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     $redialing = 1;
   }
   else {
     $redialing = 0;
   }
}

#### Aquires bandwidth cap information
$filename = "/tmp/.slowmedown";
$slowwaydown = "/tmp/.whoaNelly";

if (file_exists($filename)) {
  $bandwidthcap = 1;
}
else if (file_exists($slowwaydown)) {
  $bandwidthcap = 2;
}
else {
  $bandwidthcap = 0;
}

#### Aquires the clock time
$clocktime = shell_exec("date");

#### Aquires MST Time
#trim(system("date")) #old system call, shows UTC only
$routertime=chop(shell_exec("date"));

$UTCTZ = new DateTimeZone('UTC');
$MNTTZ = new DateTimeZone('America/Denver');

$dt = new DateTime($routertime, $UTCTZ);
$dt->setTimezone($MNTTZ);
$mountaintime=$dt->format(DATE_RFC822);
$unixtimestamp=$dt->format('U');



#### Aquires bucket usage
$bucketusage = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 1");
$bucketprefix = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 2");
$rxtotal = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$txtotal = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$rxprefix = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
$txprefix = shell_exec("vnstat -w -i ppp0 | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
if (preg_match ( "/MiB/", $bucketprefix)) {
  if ($bucketusage <= 1024) {
    $buckettotalusage = $bucketusage / 1024;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = 0;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / $bucketusage;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / $bucketusage;
    } else {
      $buckettx = 0;
    }
  }
}
else if (preg_match ( "/GiB/", $bucketprefix)) {
  if ($bucketusage <= 1) {
    $buckettotalusage = $bucketusage;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal / $bucketusage;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal / $bucketusage;
    }
  }
}
else if (preg_match ( "/KiB/", $bucketprefix)) {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}
else {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}


$parameters = array(
        "pingArray"=> array (
                "reachable" => $pingMetrics[0],
                "rtt" => $pingMetrics[1],
                "mdev" => $pingMetrics[2],
                "loss" => trim($pingMetrics[3])
        ),
	"currentProvider" => $currentprovider,
	"connection3g" => $connection3g,
	"internetstatus" => $internetstatus,
	"redailing" => $redialing,
	"connectionmetrics" => $connectionmetrics,
	"bandwidthcap" => $bandwidthcap,
	"clocktime" => $clocktime,
	"mountaintime" => $mountaintime,
        "bucket" => $buckettotalusage,
	"bucketactual" => $bucketusage,
	"bucketprefix" => $bucketprefix,
        "buckettx" => $buckettx,
        "bucketrx" => $bucketrx,
	"cards" => array (
		array("provider" => "AT&T", "rssi" => "$attrssi[0]", "roamingstatus" => "$attroaming[0]"),
		array("provider" => "Verizon", "rssi" => $verizonrssi, "roamingstatus" => $verizonroaming)
	)
);

echo json_encode($parameters);
?>
