function getLoggingParameters (wellID) {
  var selector = 'logging-parameters';
  $("#"+selector).append('<div class="log-grid" style="display: grid; justify-content: left; flex-flow: row wrap; grid-template-columns: 1fr 1fr; height: 100%; width: 100%;"></div>');
  var loggrid = document.querySelector('.log-grid');
  var statsgrid = document.querySelector('.stats-grid');
  var totalStrokesgrid = document.querySelector('.totalStrokes-grid');
  var pumpsgrid = document.querySelector('.pumps-grid');
  var miscgrid = document.querySelector('.misc-grid');
  /*$('.stats-grid').sortable({
  handle: '.drag',
  containment: 'stats-grid',
});*/


function cardInstance(id, title, value, color, status, order) {
  var order = order || null;
  var card = document.createElement('div');
  card.style.cssText = 'display: -webkit-inline-box; min-width: 135px; flex: 1; color: #000; position: relative; margin: 0 0px; margin-top: 5px; height: 36px;';
  if (title == 'surface Lag' || title == 'total Strokes' || title == 'pump Status' || title == 'average ROP') {
    card.style.flex = '0 1 30%';
  }
  card.classList.add("statcard");
  card.style.order = order;
  const cardDrag = document.createElement('div');
  cardDrag.className = 'drag';
  cardDrag.style.cssText = 'cursor: grab; height: 22px; width: 22px; position: absolute;';
  cardDrag.innerHTML = '<i style="line-height: 1.5; font-size: 16px;" class="material-icons">drag_indicator</i>';
  //card.appendChild(cardDrag);
  const cardTitle = document.createElement('div');
  cardTitle.style.cssText = 'text-align: right; width: 40%; cursor: auto; user-select: none; text-transform: capitalize; padding: 0 2px; font-size: 12px; margin: 0; padding-top: 5px;';
  if (title == "WITS Status")
  title = "EDR Status";
  cardTitle.innerHTML = title + ':';
  const cardVal = document.createElement('div');
  cardVal.style.cssText = 'border-style: inset; width: 60%; color: green; padding: 0px 10px;font-size: 16px; font-weight: 500; user-select: none; padding-top: 3px;';
  cardVal.style.color = status;
  cardVal.style.background = color;
  cardVal.innerHTML = value ? value : '-';
  if (cardVal.innerHTML >= 12) {
    cardVal.style.fontSize = '15px;';
  }
  cardVal.id = id;
  card.appendChild(cardTitle);
  card.appendChild(cardVal);

  return card;
};

//statsgrid.appendChild(cardInstance('Current Depth', '1235 ft.', '#7fc789'));
//statsgrid.appendChild(cardInstance('Bit Depth', '1235 ft.', 'rgb(169, 187, 226)'));



var localData;
var lagUnit = window.localStorage.getItem(wellID + '-lag_unit') != undefined ? window.localStorage.getItem(wellID + '-lag_unit') : 'Strokes'
var lastUpdate = window.localStorage.getItem(wellID+'-lastUpdate');
if (!lastUpdate) {
  lastUpdate = 'No updates';
}
$('.lastUpdate').text(new Date(lastUpdate).toLocaleString());

params = ['currentDepth', 'bitDepth', 'totalGas', 'holeDepth', 'laggedDepth', 'lagUnit', 'averageROP', 'bitStatus', 'surfaceLag', 'WITSStatus', 'totalStrokes', 'pumpStatus', 'pump1SPM', 'pump1Strokes', 'pump2SPM', 'pump2Strokes', 'pump3SPM', 'pump3Strokes']
params.forEach( function (key) {
  newCard(wellID + "-" + key);
})

// for (var key in localStorage)
// {
//   newCard(key);
// }




//$('.card').css('order', '')

function newCard(key) {
  if (key.includes(wellID+'-') && !(key.includes('lastUpdate') || key.includes('plot_settings') || key.includes('lag_unit') || key.includes('settings') || key.includes('chartSettings'))) {
    ////console.log('newcard:', key)
    let keyValue = window.localStorage.getItem(key) != undefined ? window.localStorage.getItem(key).toString() : '-';
    let keyName = key.substr((wellID.length + 1));
    //console.log(keyName, keyValue)
    let keyLook = statusCheck(key, keyValue);
    var loggrid = document.querySelector('.log-grid');
    // var statsgrid = document.querySelector('.stats-grid');
    // var pumpsgrid = document.querySelector('.pumps-grid');
    // var totalStrokesgrid = document.querySelector('.totalStrokes-grid');
    // var miscgrid = document.querySelector('.misc-grid');
    let grid;
    ////console.log(keyName)
    //let options = [keyName, keyName.replace(/([a-z])([A-Z])/g, '$1 $2').replace(/\b([A-Z]+)([A-Z])([a-z])/, '$1 $2$3'), window.localStorage.getItem(key), keyLook.color, keyLook.status, keyLook.order]
    // if (!keyName.includes('Status') && keyName.includes('pump') || keyName.includes('Strokes')) {
    //   grid = pumpsgrid;
    //   if (keyName == "totalStrokes" | keyName == "lagStrokes") {
    //     grid = totalStrokesgrid;
    //   }
    // } else if (keyName.includes('Status')) {
    //   grid = statsgrid;
    // } else if (['currentDepth', 'bitDepth', 'totalGas','laggedDepth','holeDepth','lagTime','averageROP','surfaceLag'].indexOf(keyName) != -1) {
    //   grid = loggrid;
    // } else {
    //   grid = miscgrid;
    // }
    let title = (keyName == 'lagUnit') ? 'Lag ' + lagUnit : keyName.replace(/([a-z])([A-Z])/g, '$1 $2').replace(/\b([A-Z]+)([A-Z])([a-z])/, '$1 $2$3').replace(/\d+/, ' $& ')
    $('.progress-logging-parameters').hide();
    loggrid.appendChild(cardInstance(keyName, title , window.localStorage.getItem(key), keyLook.color, keyLook.status, keyLook.order));
  }
}
var witsError = false;

var currentDepth;
function statusCheck(key, keyValue) {
  let keyName = key.substr((wellID.length + 1));
  if(keyName.includes('WITSStatus')) {
    witsError = (keyValue.toLowerCase().includes('error'));
  } else {
    keyName = keyName.replace(/([a-z])([A-Z])/g, '$1 $2').replace(/\b([A-Z]+)([A-Z])([a-z])/);
  }
    //console.log(keyName, keyValue)
  var status = 'lime';
  var color = '#000';
  var order = null;
  if (keyName == 'hole Depth') {
    currentDepth = parseFloat(keyValue.slice(0,-3).replace(',',''));
  }
  if (keyName == 'current Depth') {
    let currentDepth2 = parseFloat(keyValue.slice(0,-3).replace(',',''))
    ////console.log(currentDepth2,currentDepth)
    if (currentDepth2 > (currentDepth + 5) || currentDepth2 < (currentDepth - 5 ))
    status = 'red';
  }
  //test for numbers
  ///\d/.test(keyName) ? null : color = '#666';
  //test for pump in name
  if (keyName.includes('pump') || keyName.includes('Strokes') || keyName.includes('ROP') || !keyName.includes('Status')) {
    //color = 'rgba(87, 59, 241, 0.1)';
    order = 1;
  }
  if (keyName.includes('total Gas')) {
    //color = 'rgba(241, 59, 59, 0.1)'
    order = 2;
  }
  if (keyName.includes('bit Status')) {
    //color = 'rgba(255, 248, 16, 0.1)'
    order = 3;
  }
  if (keyValue.toString().includes('null') || keyValue.toString().toLowerCase().includes('error')) {
    status = 'red'
  }

  //need stale counter
  var presetOrder = {'current depth':1, 'bit depth': 6, 'total gas': 2, 'lagged depth': 3, 'hole depth': 4, 'average rop': 8, 'bit status': 9, 'lag unit': 5,'surface lag': 7, 'witsstatus': 10, 'total strokes': 12, 'pump status': 11, 'pump1spm': 13, 'pump1strokes': 14, 'pump2spm': 15, 'pump2strokes': 16, 'pump3spm': 17, 'pump3strokes': 18}
  // window.onresize = function () {
  //   let w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
  //   if ( w < 1494 ) {
  //     // if (title == 'surface Lag' || title == 'total Strokes' || title == 'pump Status' || title == 'average ROP') {
  //     //   card.style.flex = '0 1 30%';
  //     //   card.style.marginRight = '0';
  //     // }
  //     presetOrder = {'current depth':1, 'bit depth': 6, 'total gas': 2, 'lagged depth': 3, 'hole depth': 5,  'average rop': 8, 'bit status': 6, 'surface lag': 4, 'wits status': 7, 'total strokes': 4, 'pump status': 10, 'pump1spm': 5, 'pump1strokes': 6, 'pump2spm': 7, 'pump2strokes': 8, 'pump3spm': 9, 'pump3strokes': 10}
  //   }
  // }
  order = presetOrder[keyName.toLowerCase()];

  if (keyName.includes('pump') & !keyName.includes('Status')) {
    ////console.log(keyName, keyName[4])
    status = document.getElementById('Pump' + keyName[4] + 'Use').checked ? status : 'silver';
  }
  //test for status in name
  if (keyName.includes('Status')) {
    ////console.log(keyName)
    switch (keyValue) {
      case 'Circulating':
      case 'On Bottom':
      case 'OK':
      case 'Good':
      status = 'lime';
      break;
      case 'Not Circulating':
      case 'Off Bottom':
      status = 'orange';
      break;
      default:
      status = 'red';
      break;
    }
  }
  if (keyValue == '-')
  status = 'silver';
  return {color: color, status: status, order: order};
}
//var holeDepth = window.localStorage.getItem(wellID+'-holeDepth');
//statsgrid.appendChild(cardInstance('Hole Depth', holeDepth + ' ft.', '#7fc789'));
//var bitDepth = window.localStorage.getItem(wellID+'-bitDepth');
//statsgrid.appendChild(cardInstance('Bit Depth', bitDepth + ' ft.', 'rgb(127, 182, 199)'));

getConsoleData()
setInterval( function(){
  if (witsError == true) {
    $(document.getElementById('WITSStatus')).effect('highlight', { color: 'red'}, 800, function () {
      if (!witsError) {
        document.getElementById('WITSStatus').style.color = 'lime';
      }
    });
  }
}, 1000);

var recivedWits = [];

function getConsoleData () {
  $.get('./LinkNLog/REST/data/allLoggingParameters', function (reqConsole) {
    //offline debug
    // if (reqConsole[0] == '<') {
    //   console.warn("/LinkNLog/REST/data/allLoggingParameters not running -- replaced with dummy data.");
    //   reqConsole = {"WITSStatus":"Error","averageROP":"251 min","totalStrokes":"2511","pump1Strokes":"900","pump2Strokes":"900","pump3Strokes":"700","lagTime":"13 min","currentDepth":"1008 FT","laggedDepth":"312 FT","surfaceLag":"6 min","pump1SPM":"000 SPM","pump2SPM":"51 SPM","pump3SPM":"232 SPM","bitDepth":"1017 FT","holeDepth":"1022 FT","bitStatus":"On Bottom","pumpStatus":"Not Circulating"}
    // }
    ////console.log('console data recived: ', reqConsole)
    //change to object.keys for each
    window.localStorage.setItem(wellID+'-lastUpdate', new Date());
    lastUpdate = new Date(window.localStorage.getItem(wellID+'-lastUpdate'));
    $('.lastUpdate').text($.format.date(lastUpdate, 'dd-MMM-yyyy HH:mm:ss'));
    recivedWits = [];
    Object.keys(reqConsole).forEach( function (consoleData) {
      let consoleName = consoleData.replace(/\s/g, '');
      if (consoleName == 'lagStrokes')  {
        lagUnit = 'Strokes'
        window.localStorage.setItem(wellID+'-'+'lag_unit', lagUnit);
        consoleName = 'lagUnit'
      }
      if (consoleName == 'lagTime')  {
        lagUnit = 'Time'
        window.localStorage.setItem(wellID+'-'+'lag_unit', lagUnit);
        consoleName = 'lagUnit'
      }
      //let domName = consoleData.replace(/([a-z])([A-Z])/g, '$1 $2').replace(/\b([A-Z]+)([A-Z])([a-z])/, '$1 $2$3');
      ////console.log(domName);
      recivedWits.push(consoleName);
      ////console.log(recivedWits)
      if (document.getElementById(consoleName) == null) {
        window.localStorage.setItem(wellID+'-'+consoleName, reqConsole[consoleData]);
        newCard(wellID+'-'+consoleName);
      } else {
        let consoleCard = document.getElementById(consoleName);
        // if ('totalGas' == consoleName)
        // ////console.log(reqConsole[consoleData],  window.localStorage.getItem(wellID+'-'+consoleName))
        // if ((reqConsole[consoleData]) != window.localStorage.getItem(wellID+'-'+consoleName)) { //could remove to fix update bug
        window.localStorage.setItem(wellID+'-'+consoleName, reqConsole[consoleData]);
        consoleCard.innerHTML = reqConsole[consoleData];
        //console.log(consoleName, reqConsole[consoleData])
        consoleCard.style.color = statusCheck(wellID+'-'+consoleName, reqConsole[consoleData]).status;
        //$(consoleCard).effect('highlight', { times: 1 });
        //}
      }
    });
    Array.from(document.getElementsByClassName('statcard')).forEach( function (stat) {
      ////console.log(stat.children[1], Object.keys(reqConsole))
      ////console.log(recivedWits);
      if (!(recivedWits.indexOf(stat.children[1].id) > -1)) {
        stat.children[1].style.color = 'silver';
      }
      if (stat.children[1].id == "lagUnit") {
          stat.children[0].innerText = 'Lag ' + lagUnit
      }
       // else {
        // stat.children[1].style.color = statusCheck(wellID+'-'+stat.children[1].id, reqConsole[stat.children[1].id]).status;
      // }
    });

    setTimeout(getConsoleData, 2000);
  }).fail( function (error) {
    recivedWits = [];
    Array.from(document.getElementsByClassName('statcard')).forEach( function (stat) {
      ////console.log(stat.children[1], Object.keys(reqConsole))
      ////console.log(recivedWits);
      if (!(recivedWits.indexOf(stat.children[1].id) > -1)) {
        stat.children[1].style.color = 'silver';
      }
      //  else {
      //   stat.children[1].style.color = statusCheck(wellID+'-'+stat.children[1].id, reqConsole[stat.children[1].id]).status;
      // }
    });
    //console.log("unable to get new console data: " + error.status);
    setTimeout(getConsoleData, 10000);
  })
}

}
