/*
GET and POST Parameters

currentDepth, lagAmt - float, lagInc - float, lagMode - float, TGCurvesUnit - String, GCCurvesUnit - String, forceOnBottom - boolean, enableWITSChromatOutput - boolean,
WITSGasTag - String, SPMCutoff - float, offBotomThreshold - float, ROPPlotMode - String, surfaceLagMin - float, depthUnits - String, unitsPerTic - float,
normalizingGas - boolean, interpolatingTics - boolean, maxInterpolationDistance - float, pump1output - float, pump2output - float, pump3output - float,
GCInterpolation - String
*/
var depthEditedFlag = false;
var lagEditedFlag = false;
var lagIncEditedFlag = false;
var lagModeEditedFlag = false;

var aRadio = document.getElementsByClassName('lagMode');
var i = aRadio.length;
for(var j = 0; j < i; j++){
  aRadio[j].addEventListener('click', function (e) {
    lagSwitch(e.currentTarget.value);
    //$.post(endpoint + 'setup/lagMode'); waiting implementation
    //getSettings();
  })
}

$(document).on("wheel", "input[type=number]", function (e) {
  return false;
});

function submitSettings(){
  loadWitsDevices(function () {
    $.post(endpoint + "wits/witsNormalizing?device=" + witsDevices['COM1'] + "&status=" + $("#WITSChromatOutput1").prop("checked") , function (res) {
    })

    $.post(endpoint + "wits/witsNormalizing?device=" + witsDevices['COM2'] + "&status=" + $("#WITSChromatOutput2").prop("checked"), function (res) {
    })

    $.post(endpoint + "wits/witsTotalGasUnit?device=" + witsDevices['COM1'] + "&unit=" + $("input[name='TGCurvesUnit1']:checked").val() , function (res) {
    })

    $.post(endpoint + "wits/witsTotalGasUnit?device=" + witsDevices['COM2'] + "&unit=" + $("input[name='TGCurvesUnit2']:checked").val(), function (res) {
    })

    $.post(endpoint + "wits/witsChromatUnit?device=" + witsDevices['COM1'] + "&unit=" + $("input[name='GCCurvesUnit1']:checked").val(), function (res) {
    })

    $.post(endpoint + "wits/witsChromatUnit?device=" + witsDevices['COM2'] + "&unit=" + $("input[name='GCCurvesUnit2']:checked").val(), function (res) {
    })
  });
  if(document.getElementById("GCInterpolation").checked){
    document.getElementById("GCInterpolationHidden").disabled = true;
  } else document.getElementById("GCInterpolationHidden").disabled = false;
  if(document.getElementById("SurfaceLag").checked){
    document.getElementById("SurfaceLagHidden").disabled = true;
  } else document.getElementById("SurfaceLagHidden").disabled = false;
  if(document.getElementById("normalizingGas").checked){
    document.getElementById("normalizingGasHidden").disabled = true;
  } else document.getElementById("normalizingGasHidden").disabled = false;
  if(document.getElementById("forceOnBottom").checked){
    document.getElementById("forceOnBottomHidden").disabled = true;
  } else document.getElementById("forceOnBottomHidden").disabled = false;
  if(document.getElementById("interpolatingTics").checked){
    document.getElementById("interpolatingTicsHidden").disabled = true;
  } else document.getElementById("interpolatingTicsHidden").disabled = false;
  if(document.getElementById("Pump1Use").checked){
    document.getElementById("Pump1UseHidden").disabled = true;
  } else document.getElementById("Pump1UseHidden").disabled = false;
  if(document.getElementById("Pump2Use").checked){
    document.getElementById("Pump2UseHidden").disabled = true;
  } else document.getElementById("Pump2UseHidden").disabled = false;
  if(document.getElementById("Pump3Use").checked){
    document.getElementById("Pump3UseHidden").disabled = true;
  } else document.getElementById("Pump3UseHidden").disabled = false;
  if (!depthEditedFlag) {
    document.getElementById("currentDepth_").disabled = true;
  } else document.getElementById("currentDepth_").disabled = false;
  if (!lagEditedFlag && !lagModeEditedFlag) {
    document.getElementById("lagAmt").disabled = true;
  } else document.getElementById("lagAmt").disabled = false;
  if (!lagIncEditedFlag) {
    document.getElementById("lagInc").disabled = true;
  } else document.getElementById("lagInc").disabled = false;
  if (!lagModeEditedFlag) {
    document.getElementById("onPump").disabled = true;
    document.getElementById("onBottom").disabled = true;
    document.getElementById("pumpStrokes").disabled = true;
  } else {
    document.getElementById("onPump").disabled = false;
    document.getElementById("onBottom").disabled = false;
    document.getElementById("pumpStrokes").disabled = false;
  }
  if(document.getElementById("THAOverride").checked){
      document.getElementById("THAOverrideHidden").disabled = true;
  } else document.getElementById("THAOverrideHidden").disabled = false;
  document.getElementById("mainSettings").submit()
}

$('#settingsModal').on('hidden.bs.modal', function (e) {
  updateROPUnit();
  depthEditedFlag = false;
});

$('#currentDepth_').on('change', function (e) {
  depthEditedFlag = true;
})

$('#lagInc').on('change', function (e) {
  lagIncEditedFlag = true;
})

$('#pumpStrokes').on('change', function (e) {
  lagModeEditedFlag = true;
})

$('#onBottom').on('change', function (e) {
  lagModeEditedFlag = true;
})

$('#onPump').on('change', function (e) {
  lagModeEditedFlag = true;
})

$('#lagAmt').on('change', function (e) {
  lagEditedFlag = true;
})

$('#THAOverride').on('change', function (e) {
  //$('#sumMethodRadioButtons').children().prop('disabled', !this.checked);
  $('.THAOverrideMethod').prop('disabled', !this.checked);
})

$('#settingsModal').on('show.bs.modal', function (e) {
  getSettings();
  document.getElementById("lagInc").disabled = false;
  document.getElementById("currentDepth_").disabled = false;
  document.getElementById("lagAmt").disabled = false;
  document.getElementById("onPump").disabled = false;
  document.getElementById("onBottom").disabled = false;
  document.getElementById("pumpStrokes").disabled = false;
  document.getElementById("SurfaceLag").disabled = false;
})


function lagSwitch(lagMode) {
  var logParm = document.getElementsByClassName('lag-unit'), i = logParm.length;
  var lagUnit = "Min";
  if (lagMode == "pumpStrokes") {
    lagUnit = "Stks";
  }
  for(var j = 0; j < i; j++) {
    logParm[j].innerHTML = lagUnit;
  }
}

$("[name=ZeroStrokeCounter]").on('click', function (e) {
  $.post(endpoint + 'data/zeroStrokes');
  getSettings();
})

$('#nukedModal').on('shown.bs.modal', function (e) {
  setTimeout(function () {$('.modal-backdrop').fadeTo(5000, .98)}, 1000);
});

$("#nukeConfirm").on('click', function (e) {
  console.log('nuking')
  $('#nukeModal').modal('hide');
  $('#settingsModal').modal('hide');
  $('#nukedModal').modal({
    backdrop: 'static',
    keyboard: false
  })
  $.post('./cgi-bin/modules/nuke_box.cgi', function () {
  })
  time=90,r=document.getElementById('refreshTimer'),tmp=time;
  let timer = setInterval(function(){
    var c=tmp--,m=(c/60)>>0,s=(c-m*60)+'';
    r.textContent=m+':'+(s.length>1?'':'0')+s
    tmp!=0||(tmp=time);
  },1000);
  setTimeout(function () {
    window.location.href='index.html';
  }, 90000);
  setTimeout(function () {
    clearInterval(timer);
    setTimeout(function () { r.parentElement.innerHTML = "<span class='text-danger text-weight-bold'>Unresponsive: </span></br><span>Check “I'm Alive“ light</br>then refresh.</span>" }, 3000);
  }, 90500);

});


$("[name=Reboot]").on('click', function (e) {
  $(document.body).addClass('shutdown');
  $.post(endpoint + 'system/reboot');

  setTimeout(function () {
    $.notify({
    title: 'Rebooting: ',
    message: 'Automaticlly refreshing in '
  },{
    element: 'html',
    allow_dismiss: false,
    delay: 0,
    type: 'minimalist',
    template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
    '<span data-notify="title">{1}</span>' +
    '<span data-notify="message">{2}<span id="refreshTimer2"></span>.</span>' +
    '</div>',
    placement: {
      from: "top",
      align: "center"
    },
    animate: {
      enter: 'animated fadeInDown'
    },

  })
  time=90,r=document.getElementById('refreshTimer2'),tmp=time;
  let timer = setInterval(function(){
    var c=tmp--,m=(c/60)>>0,s=(c-m*60)+'';
    r.textContent=m+':'+(s.length>1?'':'0')+s
    tmp!=0||(tmp=time);
  },1000);
  setTimeout(function () {
    window.location.href=window.location.href;
  }, 90000);
  setTimeout(function () {
    clearInterval(timer);
    setTimeout(function () { r.parentElement.innerHTML = "<span class='text-danger text-weight-bold'>Unresponsive: </span></br><span>Check “I'm Alive“ light</br>then refresh.</span>" }, 3000);
  }, 90500);

}, 5000);
})

$("[name=Shutdown]").on('click', function (e) {
  $(document.body).addClass('shutdown');
  $.get('./cgi-bin/modules/shutdown.php');
  setTimeout(function () {$.notify({
    title: 'Shutdown Complete: ',
    message: 'Safe to power down the device.',
  },{
    element: 'html',
    allow_dismiss: false,
    delay: 0,
    type: 'minimalist',
    template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
    '<span data-notify="title">{1}</span>' +
    '<span data-notify="message">{2}</span>' +
    '</div>',
    placement: {
      from: "top",
      align: "center"
    },
    animate: {
      enter: 'animated fadeInDown'
    },
  })}, 5000);
})


function getSettings () {
  $.get(endpoint + "setup/setupMenuData", function (setup_Res) {
    Object.keys(setup_Res).forEach( function (key) {
      //console.log(key, setup_Res[key])
      if(!key.includes("Pump") && !key.includes("Use"))$("[name='"+key+"']").not("[id*='Hidden']").not("select").not("[type=radio]").not("[type=checkbox]").val(setup_Res[key]); // select by type if not select or aRadio
      $("select[name='"+ key +"']").find('[value="' + setup_Res[key] + '"]').attr('selected');
      if ($('[type=radio][name="'+key+'"][value="'+setup_Res[key]+'"]').length > 0)
      $('[type=radio][name="'+key+'"][value="'+setup_Res[key]+'"]')[0].checked = true;
      if (key == "lagMode") lagSwitch(setup_Res[key]);
      if(setup_Res[key] == "on" || setup_Res[key] == true)$('[type=checkbox][name="'+key+'"]').prop('checked', true);
      else {
        //$('[type=checkbox][name="'+key+'"],[type=checkbox][value="'+setup_Res[key]+'"]');
        //console.log("off: " + key);
      }
      if(key == "overrideTotalGas") $('.THAOverrideMethod').prop('disabled', !setup_Res[key]);
    })
  })
  loadWitsDevices(function () {
    $.get(endpoint + "wits/witsNormalizing?device=" + witsDevices['COM1'], function (res) {
      $('#WITSChromatOutput1').prop('checked', JSON.parse(res));
    })

    $.get(endpoint + "wits/witsNormalizing?device=" + witsDevices['COM2'], function (res) {
      // console.log(res);
      $("#WITSChromatOutput2").prop('checked', JSON.parse(res));
    })

    $.get(endpoint + "wits/witsTotalGasUnit?device=" + witsDevices['COM1'], function (res) {
      $('[type=radio][name="TGCurvesUnit1"][value="'+res+'"]')[0].checked = true;
    })

    $.get(endpoint + "wits/witsTotalGasUnit?device=" + witsDevices['COM2'], function (res) {
      $('[type=radio][name="TGCurvesUnit2"][value="'+res+'"]')[0].checked = true;
    })

    $.get(endpoint + "wits/witsChromatUnit?device=" + witsDevices['COM1'], function (res) {
      $('[type=radio][name="GCCurvesUnit1"][value="'+res+'"]')[0].checked = true;
    })

    $.get(endpoint + "wits/witsChromatUnit?device=" + witsDevices['COM2'], function (res) {
      $('[type=radio][name="GCCurvesUnit2"][value="'+res+'"]')[0].checked = true;
    })
  });
}
