#!/usr/bin/php-cgi
<!DOCTYPE html>
<html lang="en">
<head>
<title>MLogger - Network</title>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta name="description" content="">
<meta name="author" content="">
<link rel="icon" href="../imgs/lnl_favicon.png">

<!-- Bootstrap core CSS -->
<link href="../css/bootstrap.min.css" rel="stylesheet">

<!-- Icon Font CSS -->
<link rel="stylesheet" href="../css/materialdesignicons.min.css">

<!-- Custom styles for this page -->
<link href="../css/main.css" rel="stylesheet">
<style>
#modalNetworkPW .modal-dialog {
margin: 1rem 42%;
}
#modalNetworkPW .modal-content {
width: 270px;
}

#modalNetworkPW .modal-footer {
padding-right: 0;
}

</style>

</head>

<body class="bg-light">

<nav class="navbar navbar-expand-sm fixed-top navbar-light bg-beige shadow-sm px-2">
<button class="navbar-toggler p-0 border-0" type="button" data-toggle="offcanvas">
<span class="navbar-toggler-icon"></span>
</button>

<div class="navbar-collapse offcanvas-collapse" style="top: 40px;" id="navbars">
<ul class="navbar-nav mr-auto">
<li class="nav-item dropdown">
<a class="nav-link dropdown-toggle" id="helpDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" href="#">Help</a>
<div class="dropdown-menu dropdown-menu-left" aria-labelledby="helpDropdown">
<a class="dropdown-item" href="#" onclick="feedback.open();">Report/Feedback</a> <!-- email dialog and screenshot capture possibly remote veiwer in future -->
<a class="dropdown-item" href="dashboard.html#about" data-toggle="modal" data-target="#aboutModal">About</a> <!-- conatins whats new and version number -->
</div>
</li>
</ul>
</div>
<div class="pl-3 pr-2 font-weight-bold text-right" style="top: 2px; position: relative;">MLogger Router </br> <small class="text-center" style="padding-right: 2px;top: -5px;position: relative;"><span class="serialID"></span></small></div>
<i class="navbar-brand ml-auto ml-lg-0"><img src="../imgs/tcontrol_logo.png" width="30" height="30" class="mr-1 d-inline-block align-top" alt=""></i>
</nav>
</div>
<main role="main" class="container">
<div class="row">
<div class="col">
<div class="shadow-sm mt-3 card bg-white">
<h5 class="card-header h-secondary">Internet Connection:<span style="color: rgb(0, 248, 0); float: right; background: #9fa3a7;" id="route" class="badge badge-pill align-text-bottom"></span></h5>
<div class="card-body mt-1">
<div class="col f-table">
<div id="Ethernet">WAN - Ethernet: <span class="wanip"></span></div>
<div id="4GLTE">WAN - 4G LTE: <span class="4gip"></span></div>
<div>VPN IP: <span class="vpnip"></span></div>
<div>TerraSLS Servers Reachable: <span><div class="d-inline" id="serversReachable"></div><div class="d-inline" id="networkLatency"></div></span></div>
<div>Packet Loss: <span id="packetLoss"></span></div>
</div>
</div>
</div>
</div>

<div class="col">
<div class="shadow-sm mt-3 card bg-white">
<h5 class="card-header h-note">General Info</h5>
<div class="card-body mt-1">
<div class="col f-table">
<div>Serial: <span class="serialID"></span></div>
<div>Version: <span class="versionID"></span></div>
<div>Router Time (<i id="timezone">---</i>): <span id="clocktime"></span></div>
</div>
</div>
</div>
</div>


</div>
</div>

<div class="row">
<div class="col-md-12">
<div class="shadow-sm mt-3 card bg-white">
<h5 class="card-header h-primary">WiFi Connection</h5>
<div class="card-body pb-0">
<div class="row">
<div class="col">
<h6 class="w-100 d-flex justify-content-center mt-1">MLogger WiFi Hotspot</h6>
<div class="form-group mx-auto pt-1">
<form class="preventdefault mx-auto pb-4 clearfix" style="width: 270px" name="changeRouterPW">
<div class="form-group row">

<label for="routerSSID" class="col-sm-4 col-form-label">
SSID
</label>
<div class="col-sm-8">
<input disabled type="SSID" id="routerSSID" class="form-control mb-1" name="routerSSID">
</div>
</div>
<div class="form-group row">
<label for="routerPW" class="col-sm-4 col-form-label">
Password
</label>
<div class="col-sm-8">
<input type="password" id="routerPW" class="form-control" name="routerPW">
</div>
</div>
<div class="row pt-3">
<div class="col pr-0">
<div class="form-check float-left">
<label for="updateRouterPW" class="form-check-label">
<input type="checkbox" id="updateRouterPW" class="form-check-input" value=""
onchange="routerPW.type = routerPW.type === 'password' ? 'text' : 'password'">
Show Password
</label>
</div>
</br>
<small class="position-absolute d-flex" style="padding-left: 8em; padding-top: 1em;" id="routermsg">&nbsp</small>
</div>
<div class="col px-0">
<button type="submit" id="saveButton" class="btn btn-secondary btn-sm float-right" style="margin-right: -19px;">Save Changes</button>
</div>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>

<div class="modal" tabindex="-1" role="dialog" id="aboutModal">
<div class="modal-dialog mx-auto" role="document" style="margin-top: 17em; margin-left: 30%!important;">
<div class="modal-content" style="width: 730px;">
<div class="modal-header h-primary">
<h3 class="modal-title">About</h3>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body">
<h4>Link-n-Log<img src="../imgs/lnl_logo.png" width="30" height="30" class="mx-3 d-inline-block align-top" alt=""></h4>
<p>
Serial: <span class="serialID"></span>
Version: <span class="versionID"></span>
WellID: <span id="wellID"></span>
<textarea disabled id="changelog" style="height: 226px; width: 100%;"></textarea>
Copyright &copy 2019 Terra SLS Inc.
</p>
</div>
</div>
</div>
</div>


<div class="modal" tabindex="-1" role="dialog" id="diagnosticModal">
<div class="modal-dialog" role="document" style="margin-top: 4em; margin-left: auto; margin-right: 50%;">
<div class="modal-content">
<div class="modal-header">
<h3 class="modal-title">Diagnostics</h3>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body">
<textarea disabled id="mmcli" style="font-family: monospace; height: 626px; width: 950px;"></textarea>
<div class="custom-control custom-switch">
<input type="checkbox" class="custom-control-input" id="bandCap">
<label class="custom-control-label" for="bandCap">Override Bandwidth Cap</label>
</div>
<label for="overridePass">Password:</label>
<input type="password" id="overridePass" name="overridePass">
</div>
</div>
</div>
</div>


<div class="modal fade" id="modalNetworkPW">
<div class="modal-dialog">
<div class="modal-content bg-white">
<div class="modal-header btn-primary">
<h5 class="modal-title">WiFi Login</h5>
<button type="button" class="close text-light" data-dismiss="modal">
<span>×</span>
</button>
</div>
<div class="modal-body">
<form name="login" class="preventdefault">
<div class="form-group">
<h6 class="ssid"></h6>
<label for="networkPW">Enter the network security key</label>
<input type="password" name="networkPW" id="networkPW" class="form-control" style="width: 100%;" required="">
<input type="hidden" name="ssid" class="ssid">
<input type="hidden" name="bars" class="bars">
<input type="hidden" name="encryptionSuites">
</div>
<div class="form-check">
<label for="toggleNetworkPW" class="form-check-label">
<input type="checkbox" id="toggleNetworkPW" class="form-check-input" value="" widht="100px" onchange="networkPW.type = networkPW.type === 'password' ? 'text' : 'password'">
Show Password
</label>
</div>


<div class="modal-footer">
<button type="submit" id="savelogin" class="btn btn-primary next" disabled="">Save</button>
<button type="reset" class="btn btn-danger cancel" data-dismiss="modal">Cancel</button>
<small id="wifiInfo" style="position: absolute; bottom: 5px; left: 6px;">Connecting may take a few seconds...</small>
</div>
</form>
</div>
</div>
</div>
</div>

<div class="col-md-12">
<div class="shadow-sm mt-3 card bg-white">
<h5 class="card-header btn-primary">LTE   Connection</h5>
<div class="card-body pt-0">
<div class="col col-lg-8 mx-auto">
<!-- for now, verizon is the only option -->
<img id="currentprovider" ondblclick="openDiagnostics()" class="align-bottom mx-auto d-block my-3" height="55px" src="../imgs/verizon_logo.png"></img>
<?php #$currentprovider = shell_exec("ls -la /etc/config/network | cut -d . -f 2"); if (preg_match("/verizon/", $currentprovider)) { print "<img id=\"currentprovider\" src=\"/assets/images/provider_logo_verizon.png\" />"; } else if (preg_match("/att/", $currentprovider)) { print "<img id=\"currentprovider\" src=\"/assets/images/provider_logo_att.png\" />"; } ?>
<?php require('./modules/bandwidth-cap.php'); ?>
<hr>
<div class="row">
<div class="col">
<h6 class="mt-3">CONNECTION STATUS</h6> <?php require('./modules/verizon_status.php')?> <!-- ADDED by EPA 11-OCT-2018 21:38 -->
<div class="d-flex mt-2">
<?php
if ($verizonrssi < 20 ) {
  echo '<div class="signal-bars mt1 sizing-box bad one-bar" title="-'.$verizonrssi.'%">';
}
elseif ($verizonrssi < 45) {
  echo '<div class="signal-bars mt1 sizing-box ok two-bars" title="-'.$verizonrssi.'%">';
}
elseif ($verizonrssi < 65) {
  echo '<div class="signal-bars mt1 sizing-box ok three-bars" title="-'.$verizonrssi.'%">';
}
elseif ($verizonrssi < 75) {
  echo '<div class="signal-bars mt1 sizing-box good four-bars" title="-'.$verizonrssi.'%">';
}
elseif ($verizonrssi < 90) {
  echo '<div class="signal-bars mt1 sizing-box good five-bar" title="-'.$verizonrssi.'%">';
}
?>
<div class="first-bar bar"></div>
<div class="second-bar bar"></div>
<div class="third-bar bar"></div>
<div class="fourth-bar bar"></div>
<div class="fifth-bar bar"></div>
</div>
<div id="verizonroaming" class="align-bottom text-muted"> <?php echo  $verizonService.' ' ?> <?php str_replace(" ", "", $verizonrssi); echo $verizonrssi.'% signal' ?> - <?php echo " ".$verizonroaming; ?></div>
</div>
</div>
<div class="col">
<div class="gadget">
<h6 class="user">BANDWIDTH USAGE <em>(Weekly)</em></h6>
<?php require('./modules/bandwidth-usage.php'); ?>
<p id="counter" class="global-value"><?php print ' '.(1024 - (round($buckettotalusage))).' MB'; ?></p>
</div>
</div>
</div>
</div>
</div>
<div class="col col-lg-8 mx-auto card card-body mt-3" style="font-size: small;">
<div class="about">
<p>
Capped Status:
<span id="cappedStatus">
<?php require('./modules/capped-status.php'); ?>
</span>
</p>
<em>Bandwidth usage is tracked only on the LTE cellular connection.<br>
This data plan allows 1GB (1024 MB) per week (current week), and is throttled beyond that.</em>
</div>
</div>
</div>
</div>
</div>

<div class="col-md-12">
<div class="shadow-sm my-3 card bg-white">
<h5 class="card-header  btn-primary">Connected Devices
<span id="numConnectedDevices" style="background: #2771d2;" class="badge badge-pill align-text-bottom">-</span></h5>
<div class="card-body">
<div class="table-responsive-sm">
<table class="table">
<thead>
<tr>
<th scope="col"></th>
<th scope="col">ID</th>
<th scope="col">MAC</th>
<th scope="col">Version</th>
<th scope="col">IP</th>
</tr>
</thead>
<tbody id="connectedDevicesList">

</tbody>
</table>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</main>

<!-- Bootstrap core JavaScript
================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="../js/jquery-3.3.1.min.js"></script>
<script src="../js/jquery-ui.min.js"></script>
<script src="../js/bootstrap.bundle.js"></script>
<script src="../js/sideMenu.js"></script>
<script src="../js/wifi-icon.js"></script>
<script src="../js/feedback.js"></script>
<script> var networkLoc = "./"</script>
<script src="../js/network.js"></script>
<script>
var feedback = new Feedback();
</script>

<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" preserveAspectRatio="none" style="display: none; visibility: hidden; position: absolute; top: -100%; left: -100%;"><defs><style type="text/css"></style></defs><text x="0" y="2" style="font-weight:bold;font-size:2pt;font-family:Arial, Helvetica, Open Sans, sans-serif">32x32</text></svg></body></html>
