#!/usr/bin/php-cgi
<?php

#### Aquires the bacode "ML-###"
$boxnum=shell_exec("cat /etc/ML-BOX");

#### Aquires Verizon RSSI value and strings used by bandwidth.cgi
$verizonoutput = file("/tmp/verizonmetrics");
$verizonrssi = explode("\n", $verizonoutput[0]);
$verizonroaming = explode("\n", $verizonoutput[1]);

#### Aquires AT&T RSSI value and strings used by bandwidth.cgi
$attOutput = file('/tmp/attmetrics');
$attrssi = explode("\n", $attOutput[0]);
$attroaming = explode("\n", $attOutput[1]);

#### Aquires ping information from /tmp/pingcheck.txt
if (file_exists('/tmp/pingcheck.txt')) {
$pingOutput = file('/tmp/pingcheck.txt');
$pingMetrics = explode(" ", $pingOutput[0]);
}

#### Aquires VPN status and IP
$vpnstatus = "Inactive";
if (shell_exec("ifconfig tap0")) {
  $vpnstatus = "Active";
  $tap0ip = shell_exec("ifconfig tap0 | grep -i inet | cut -d : -f 2 | cut -d ' ' -f 1");
}

#### Aquires the clock time
$clocktime = shell_exec("date");

#### Aquires bucket usage
$bucketusage = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 1");
$bucketprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 2");
$rxtotal = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$txtotal = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$rxprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
$txprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
if (preg_match ( "/MiB/", $bucketprefix)) {
  if ($bucketusage <= 1024) {
    $buckettotalusage = $bucketusage / 1024;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = 0;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / $bucketusage;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / $bucketusage;
    } else {
      $buckettx = 0;
    }
  }
}
else if (preg_match ( "/GiB/", $bucketprefix)) {
  if ($bucketusage <= 1) {
    $buckettotalusage = $bucketusage;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal / $bucketusage;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal / $bucketusage;
    }
  }
}
else if (preg_match ( "/KiB/", $bucketprefix)) {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}
else {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}

#### Normalize rx and tx values to MiB

if (preg_match ( "/KiB/", $rxprefix)) {
  $normrx = $rxtotal / 1024;
} else if (preg_match ( "/GiB/", $rxprefix)) {
  $normrx = $rxtotal * 1024;
} else {
  $normrx = $rxtotal;
}
if (preg_match ( "/KiB/", $txprefix)) {
  $normtx = $txtotal / 1024;
} else if (preg_match ( "/GiB/", $txprefix)) {
  $normtx = $txtotal * 1024;
} else {
  $normtx = $txtotal;
}


#### Aquires the current provider
$output = shell_exec("ls -la /etc/config/network | cut -d . -f 2");

if (preg_match("/verizon/", $output)) {
  $currentprovider = "Verizon";
}
else if (preg_match("/att/", $output)) {
  $currentprovider = "AT&T";
}

#### Aquires 3g uptime
$sysuptime = shell_exec("cat /proc/uptime | cut -d ' ' -f 1 | cut -d . -f 1");
$carduptime = shell_exec("uci -P/var/state show network.3G | grep time | cut -d = -f 2");
$currentuptime = $sysuptime - $carduptime;

#### Aquires current bandwidth speed cap
$filename = "/tmp/.slowmedown";
$slowwaydown = "/tmp/.whoaNelly";
$speedcap = "N/A";

if (file_exists($filename)) {
   $speedcap = 100;
}
else if (file_exists($slowwaydown)) {
   $speedcap = 10;
}

#### Aquires the current preferred provider
$preferredProvider = shell_exec("uci get preferredprovider.@preferred[0].provider");

#### Aquires the current router version
$routerVersion = trim(shell_exec("cat /etc/ROUTER-VERSION"));

#### Aquires the wireless key
$wifiKey = trim(shell_exec("cat /etc/config/wireless | grep key | cut -d \' -f 4"));

#### Gather connection status
system("ifconfig 3g-3G | grep -i inet 1>/dev/null 2>/dev/null", $retval);

if ( $retval == "0" ) {
   $connection3g = 1;
   system("netstat -rn | grep ^0.0.0.0 | grep -i 3G 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     $internetstatus = 1;
   }
   else {
     $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
     if ( $retval == "0" ) {
       $internetstatus = 2;
     }
     else {
       $internetstatus = 0;
     }
   }
}
else
{
   $connection3g = 0;
   system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     $internetstatus = 2;
   }
   else {
   $internetstatus = -1;
   }
}

$parameters = array(
	"barcode"=>trim($boxnum),
	"pingArray"=> array (
		"reachable" => $pingMetrics[0],
		"rtt" => $pingMetrics[1],
		"mdev" => $pingMetrics[2],
		"loss" => trim($pingMetrics[3])
	),
	"bucket" => trim($buckettotalusage),
	"bucketactual" => trim($bucketusage),
	"bucketprefix" => trim($bucketprefix),
	"buckettx" => trim($buckettx),
	"bucketrx" => trim($bucketrx),
	"usageMetrics"=> array (
		"rxTotal" => trim($normrx),
                "txTotal" => trim($normtx)
	),
	"connectionTime" => trim($currentuptime),
	"ip" => trim($tap0ip),
	"vpnStatus" => trim($vpnstatus),
	"routerTime" => trim($clocktime),
	"currentProvider" => trim($currentprovider),
	"speedCap" => trim($speedcap),
	"preferredProvider" => trim($preferredProvider),
	"routerVersion" => trim($routerVersion),
	"wifikey" => trim($wifiKey),
	"connection3g" => trim($connection3g),
	"internetstatus" => trim($internetstatus),
	"cards" => array (
		array("provider" => "AT&T", "rssi" => "$attrssi[0]", "roamingstatus" => "$attroaming[0]"),
		array("provider" => "Verizon", "rssi" => $verizonrssi[0], "roamingstatus" => $verizonroaming[0])
	)
);

echo json_encode($parameters);
?>
