/*
Link-N-Log Plotting Component
v.2.0.2 - 10/17/18
MDF
*/
/*--REQUIREMENTS--*/
// jQuery


/*--UI & UX--*/
function getLanConnections() {
  $.get('./cgi-bin/modules/lanconnections.cgi', function (devicesJson) {
    var devicesArray = Object.keys(devicesJson).map(function (device) {
      devicesJson[device].MAC = device;
      return devicesJson[device]
    });
    devicesArray = debounceList(devicesArray);
    if (devicesArray.length > 0) {
    $('[id=numConnectedDevices]').text(devicesArray.length);
    let devicesList = document.createElement('div');
    let c = 0;
    devicesArray.forEach( function (device) {
      if (device.Manufacturer == "NetBurner") {
        let tr = document.createElement('tr');
        iconwrap = document.createElement('th');
        iconwrap.scope = 'row';
        icon = document.createElement('img');
        try {
          OS  = JSON.stringify(device.OS);
          icon.src = '../imgs/device_icon.png';
          if (['MSFT', 'DESKTOP', 'Wistro'].indexOf(OS) > -1) icon.src = './imgs/computer_icon.png';
          if (OS.includes('android')) icon.src = './imgs/android_icon.png';
          if (OS.includes('ios')) icon.src = './imgs/ios_icon.png';
          if (device['Client-Host-Name'].includes('THA')) icon.src = './imgs/tha_icon.png';
          if (device['Client-Host-Name'].includes('SB')) icon.src = './imgs/sb_icon.png';
          if (device['Client-Host-Name'].includes('GC')) icon.src = './imgs/gc_icon.png';
          if (device['Client-Host-Name'].includes('CDA')) icon.src = './imgs/cda_icon.png';
        } catch (e) {
          icon.src = '../imgs/device_icon.png';
        }
        icon.classList.add("mr-2", "rounded")
        icon.width = 50;
        iconwrap.appendChild(icon);
        tr.appendChild(iconwrap);
        /*
        let wits = document.createElement('td');
        let type = device['Client-Host-Name'].substr(0,3);
        console.log(type);
        switch (type) {
        case "THA":
        wits.innerHTML = '<abbr class="initialism" title="Gas (avg)">0140</abbr>';
        break;
        case "GC-":
        wits.innerHTML = '<abbr class="initialism" title="Methane (C1)">1212</abbr>, <abbr class="initialism" title="Ethane (C2)">1213</abbr>, <abbr class="initialism" title="Propane (C3)">1214</abbr>, <abbr class="initialism" title="Iso-Butane (C4)">1215</abbr>, <abbr class="initialism" title="Iso-Pentane (C5)">1217</abbr>';
        break;
        case "SB-":
        wits.innerHTML = '——';
        break;
        default:
        wits.innerText = 'Unknown';
      };*/
      let IPwrap = document.createElement('td');
      $('.progress-deviceList').hide();
      let IP = document.createElement('a');
      if (device['Client-Host-Name'] == "") device['Client-Host-Name'] = 'Unknown';
      //IP.classList.add("mx-5")
      //IP.href = "/" + device['Client-Host-Name'] + "/";
      IP.href = 'http://' + device['IP'];
      IP.target = '_blank';
      IP.classList.add('device');
      IP.style.cssText = "line-height: 1.9;"
      IP.innerText = device['Client-Host-Name'];
      IPwrap.appendChild(IP);
      //let statusWrap = document.createElement('td');
      //let statusLight = document.createElement('i');
      //statusLight.style.cssText = 'border-radius: 50%; background-color: orange; display: inline-block; height: 15px; width: 15px; margin-top: 8px;'
      //statusWrap.appendChild(statusLight);
      tr.appendChild(IPwrap);
      //tr.appendChild(statusWrap);
      //tr.appendChild(wits);
      devicesList.appendChild(tr);
      c++;
    }
  });
  $('[id=numConnectedDevices]').text(c);
  //$('[id=connectedDevicesListLoader]').remove()
  $('[id=connectedDevicesList]').html(devicesList.innerHTML);
    }
  setTimeout(getLanConnections, 15000);
}).fail( function (err) {
  setTimeout(getLanConnections, 30000);
})
//devicesArray = [{"MAC":"00:10:18:0A:BD:CC", "IP":"192.168.123.115","Manufacturer":"Broadcom","Start-Time":" 2018-10-10 20:00:16","OS":"MSFT 5.0","Client-Host-Name":"TerraSLS-PC"},{"MAC": "00:0F:92:00:F9:05", "IP":"192.168.123.253","Manufacturer":"Microhard_Systems"}]
}
var listRecord = [[],[]];
function debounceList(current) {
  listRecord.unshift(current); //pust new data to front
  if (listRecord[1].length <= current.length) { //if new data has more devices
    listRecord.pop(); //removes last in array of old data
    return current; //return new device list
  } else if ((current.length <= listRecord[2].length)) {  //if new data is not the same as both
    listRecord.pop();
    return listRecord[1]
  }
  listRecord.pop();
  return current;
}
