//DOM-EVENTS v1.1.2 by Andrii Vorobiov (https://github.com/Koorosh/dom-events)
//Adds wheel & contextmenu event to chart
//Requires Highcharts & JQuery


(function (H, $) {
  var fireEvent = H.fireEvent;

  H.wrap(H.Tooltip.prototype, 'refresh', function (proceed) {
    var args = arguments,
    points = args[1],
    point = points[0],
    chart = point.series.chart;

    // Loop over all the series of the chart
    H.each(chart.series, function(series) {
      // This one already exist
      if (series == point.series || series.visible==false || series.points.length == 0 || series.type == "xrange" || series.name.includes('Navigator 2') || series.name.includes('ticLabels')) return;

      var current,
      dist,
      distance = Number.MAX_VALUE;
      // Loop over all the points
      H.each(series.points, function(p) {
        // use the distance in X to determine the closest point
        dist = Math.abs(p.x - point.x);
        if (dist < distance) {
          distance = dist;
          current = p;
        }
      });

      // Add the closest point to the array
      if(points.indexOf(current)==-1)
      points.push(current);
    });
    // for not changing the tooltip series order
    var tt = [].slice.call(args, 1);

    //sorts by color
    tt[0].sort(function (a, b) {
      if (a.color < b.color)
      return -1;
      if (a.color > b.color)
      return 1;
      return 0;
    });

    //sorts by desired order
    let order = ['Rate of Penetration', 'Total Gas', 'Methane (C1)', 'Ethane (C2)', 'Propane (C3)', 'Iso-Butane (IC4)', 'N-Butane (NC4)', 'Iso-Pentane (IC5)', 'N-Pentane (NC5)', 'Carbon Dioxide']
    order = order.reverse();
    tt[0] = tt[0].sort(sortFunc).reverse();
    function sortFunc(a, b) {
      return order.indexOf(a.series.name) - order.indexOf(b.series.name);
    }

    // let out = tt[0].map(function (x) {
    //   return x.series.name;
    // });
    //
    // console.log(out)

    proceed.apply(this, tt);
  });

  H.wrap(H.Pointer.prototype, 'init', function (proceed) {
    proceed.apply(this, Array.prototype.slice.call(arguments, 1));

    var pointer = this,
    container = pointer.chart.container,
    DELAY = 500, clicks = 0, timer = null;

    container.oncontextmenu = function (e) {
      pointer.onContainerContextMenu(e);
    };

    container.onwheel = function (e) {
      pointer.onWheel(e);
    };

    // Override default click event handler by adding delay to handle double-click event
    container.onclick = function (e) {
      clicks++;
      if(clicks === 1) {
        timer = setTimeout(function() {
          pointer.onContainerClick(e);
          clicks = 0;
        }, DELAY);
      } else {
        clearTimeout(timer);
        clicks = 0;
      }
    };

    container.ondblclick = function (e) {
      pointer.onDblClick(e);
      clicks = 0;
    };
  });

  if(!H.Pointer.prototype.hasOwnProperty('onContainerContextMenu')) {
    H.Pointer.prototype.onContainerContextMenu = function (e) {
      var pointer = this,
      chart = pointer.chart,
      hoverPoint = chart.hoverPoint,
      plotLeft = chart.plotLeft,
      plotTop = chart.plotTop;

      e = this.normalize(e);

      if (!chart.cancelClick) {
        // On tracker click, fire the series and point events. #783, #1583
        if (hoverPoint && this.inClass(e.target, 'tracker')) {

          // the series click event
          fireEvent(hoverPoint.series, 'contextmenu', $.extend(e, {
            point: hoverPoint
          }));

          // the point click event
          if (chart.hoverPoint) {
            hoverPoint.firePointEvent('contextmenu', e);
          }
        } else {
          $.extend(e, this.getCoordinates(e));
          if (chart.isInsidePlot(e.chartX - plotLeft, e.chartY - plotTop)) {
            fireEvent(chart, 'contextmenu', e);
          }
        }
      }
    };
  }

  if(!H.Pointer.prototype.hasOwnProperty('onWheel')) {
    H.Pointer.prototype.onWheel = function (e) {
      var pointer = this,
      chart = pointer.chart,
      plotLeft = chart.plotLeft,
      plotTop = chart.plotTop;

      e = this.normalize(e);

      $.extend(e, this.getCoordinates(e));
      if (chart.isInsidePlot(e.chartX - plotLeft, e.chartY - plotTop)) {
        fireEvent(chart, 'wheel', e);
      }
    };
  }

  var applyClickEventHandler = function( eventtype, propertyName ) {
    if(!H.Pointer.prototype.hasOwnProperty(propertyName)) {
      H.Pointer.prototype[propertyName] = function (e) {
        var pointer = this,
        chart = pointer.chart,
        hoverPoint = chart.hoverPoint,
        plotLeft = chart.plotLeft,
        plotTop = chart.plotTop;

        e = this.normalize(e);

        if (!chart.cancelClick) {
          // On tracker click, fire the series and point events. #783, #1583
          if (hoverPoint && this.inClass(e.target, 'tracker')) {

            // the series click event
            fireEvent(hoverPoint.series, eventtype, $.extend(e, {
              point: hoverPoint
            }));

            // the point click event
            if (chart.hoverPoint) {
              hoverPoint.firePointEvent(eventtype, e);
            }
          } else {
            $.extend(e, this.getCoordinates(e));
            if (chart.isInsidePlot(e.chartX - plotLeft, e.chartY - plotTop)) {
              fireEvent(chart, eventtype, e);
            }
          }
        }
      };
    }
  };

  applyClickEventHandler('contextmenu', 'onContainerContextMenu');

  applyClickEventHandler('dblclick', 'onDblClick');


}(Highcharts, jQuery));
