//main.js frontend data manager and unifier
//MDF - 10/24/18

var endpoint = './LinkNLog/REST/';

function getWitsName(witsid) {
  var wits = {'1212':'Methane (C1)', '1213':'Ethane (C2)', '1214':'Propane (C3)', '1215':'Iso-Butane (IC4)','1217':'Iso-Pentane (IC5)', '0140':'Total Gas', '0113':'Rate of Penetration'};
  return wits[witsid];
}

//finds wellID and confirms same as linkbox; returns status all even return id and status in event gotWellID which means user should go through setup
function getwellID() {
  let d = new $.Deferred();
  let wellID;

  try {
    console.groupCollapsed("getwellID")
    wellID = localStorage.getItem('wellID')
    console.log('Getting wellID...')
    $.get(endpoint + 'system/uuid', function(Res_wellID) { //endpoint + 'system/wellID'
    //for debug only endpoint should return json
    if (Res_wellID[0] == '<') {
      console.warn('/LinkNLog/REST/system/wellID not running -- replaced with dummy data.')
      Res_wellID = 'Debug-001';
    }
    Res_wellID = Res_wellID.trim(); //part of debug
    //is new box or nuked
    if (Res_wellID.trim() == 'none') {
      console.warn("Connected to new LinkBox. Need setup.");
      console.groupEnd("getwellID");
      d.resolve(3);
    }
    //is new box to this computer
    else if (wellID != Res_wellID) {
      wellID = Res_wellID;
      console.warn("Local connected to new wellID: " + wellID);
      console.groupEnd("getwellID");
      localStorage.setItem('wellID', wellID);
      window.dispatchEvent(new CustomEvent('gotWellID', { detail: {'wellID': wellID, 'status': 4} }));
      d.resolve(4);
    }
    //returning connection
    else if (wellID == Res_wellID) {
      console.log("Got same wellID from LinkBox: " + wellID);
      console.groupEnd("getwellID");
      window.dispatchEvent(new CustomEvent('gotWellID', { detail: {'wellID': wellID, 'status': 0} }));
      d.resolve(0);
    } else {
      console.log('WHAT DID YOU DO?! ',wellID, Res_wellID.wellID)
      d.resolve(99);
    }
  }).fail(function (Res_error) {
    console.warn("Could not get wellID from LinkBox: " + Res_error.status);
    if (!wellID) {
      console.error('No wellID found.');
      console.groupEnd("getwellID");
      d.resolve(5);
    } else {
      console.info("Offline wellID: " + wellID);
      console.groupEnd("getwellID");
      window.dispatchEvent(new CustomEvent('gotWellID', { detail: {'wellID': wellID, 'status': 2} }));
      d.resolve(2);
      return status;
    }
  });
  return d.resolve(99);
} catch (e) {
  console.error('No local storage! Can\'t use plot.');
  console.groupEnd("getwellID");
  return d.resolve(1);
}

}
