/*

The majority of this file is event handling

Non-event handling functions are defined just prior to being used

*/
$('#disconnectWifi').hide();
$.ajax({
  url:'../ML-BOX',
  success: function (data){
    serial = document.getElementsByClassName('serialID');
    for(var i = 0; i < serial.length; i++){
      serial[i].innerText=data;
    }
  }
});
$.ajax({
  url:'../ROUTER-VERSION',
  success: function (data){
    version = document.getElementsByClassName('versionID');
    for(var i = 0; i < version.length; i++){
      var letters = /[A-Za-z]/i;
                    if(data.match(letters))
                    {
                        version[i].style.color = "red";
                    }
      version[i].innerText=data;
    }
  }
});

function getTime() {
  $.get(networkLoc + 'modules/time.php', function (time) {
    console.log(time)
    $('#timezone').text(time.slice(0,3))
    $('#clocktime').text(time.slice(4));
  })
}
getTime();
getRoute();
function getRoute() {
  $.get(networkLoc + 'modules/route.php', function (route) {
    $('#route').text(route)
    if (route == "Not Connected")
    $('#route').css('color', 'red');
    try {
      console.log(route.replace(/ /g,''))
      if (route == "4G LTE") {
        $('#4GLTE'.replace(/ /g,'').replace(':','')).css('color', 'rgb(0, 208, 0)').css('font-weight', 'bold');
        $('#Ethernet'.replace(/ /g,'').replace(':','')).css('color', 'rgb(0, 0, 0)').css('font-weight', 'normal');
      }
      if (route == "Ethernet") {
        $('#Ethernet'.replace(/ /g,'').replace(':','')).css('color', 'rgb(0, 208, 0)').css('font-weight', 'bold');
        $('#4GLTE'.replace(/ /g,'').replace(':','')).css('color', 'rgb(0, 0, 0)').css('font-weight', 'normal');                 
      }
    } catch (e) {
      console.log(e)
    }
    setTimeout(getRoute, 3000);
  })
}

$('#disconnectWifi').click( function () {
  $.get(networkLoc + 'modules/disconnectWifi.php')
  getNetwork();
})
// function tickTime() {
//   new Date($('#clocktime').text());
// }
// setTimeout(getTime, 1000)

$.ajax({
  url:'../LINKNLOG-CHANGELOG',
  success: function (data){
    document.getElementById('changelog').value = data;
  }
});

function getDiagnostic() {
  $.ajax({
    url:networkLoc + './modules/mmcli.cgi',
    success: function (data){
      document.getElementById('mmcli').value = data;
      diagTime = setTimeout(getDiagnostic, 5000);
    }
  });
}

$("#overridePass").on("change", function (e) {
    var bandCap = $("#bandCap").is(':checked') ? 1 : 0;
    if (e.target.value == "bruce2016") {
      $.get("./modules/bandwidth-cap.php?override="+bandCap);
        $("#overridePass").val("")
      $('#overideModal').modal("hide");
    }
});


function openDiagnostics() {
  $('#diagnosticModal').modal();
}
var diagTime;
$('#diagnosticModal').on('shown.bs.modal', function (e) {
  getDiagnostic();
})
$('#diagnosticModal').on('hidden.bs.modal', function (e) {
  clearTimeout(diagTime);
})

getAPNetwork();

function getAPNetwork() {
  $.get(networkLoc + 'modules/wifi-ap-info.cgi', function(res) {
    res = JSON.parse(res)
    $('#routerSSID').val(res.SSID)
    $('#routerPW').val(res.Pass)
  });

}
var myssid

function getNetwork() {
  $.get(networkLoc + 'modules/wifi-info.cgi', function(res) {
    var ip
    if (!res.match("not connected")) {
      myssid = res.match("802-11-wireless.ssid: (.*)")[1].trim();
      ip = res.match("IP4.ADDRESS(.*)")[1].slice(4).trim();
    } else {
      ip = false;
      myssid = false;
    }

    if (ip) {
      $('.wwan').text(ip)
    } else {
      $('.wwan').text("No Connection")
    }
    if(myssid) {
    changeWifiStrength(3)
    $('#connected-wifi-network').text(myssid)
    $('#disconnectWifi').show()
  } else {
    changeWifiStrength(0)
    $('#connected-wifi-network').text("Not Connected")
    $('#disconnectWifi').hide()
  }
  });
}

getNetwork();


// getAvailableNetworks2();
//
function getAvailableNetworks () {
  $('.wifi-items').html('<div id="loadingNetworks" class="clearfix"><div class="spinner-border float-right"><span class="sr-only">Loading...</span></div></div>')
  $.get(networkLoc + 'modules/availablenetworks.cgi', function(res) {
    res = JSON.parse(res)
    //console.log(res)
    if (res.availableNetworks.length > 0) {
      res.availableNetworks.sort(function (a, b) {
        return b.ssid - a.ssid;
      })
      $('.wifi-items').empty();
      for(let i = 1; i < res.availableNetworks.length; i++) {
        wifiNetwork = document.createElement('a');
        wifiNetwork.classList.add("wifi-network", "dropdown-item")
        main = document.createElement('div');
        main.classList.add("main");
        strength = document.createElement('div');
        strength.classList.add("strength");
        strengthIcon = document.createElement('i');
        icon = 'mdi-wifi-strength-' + res.availableNetworks[i].bars + (res.availableNetworks[i].encrypted == 'Secure' ? '-lock' : '')
        strengthIcon.dataset.bars = res.availableNetworks[i].bars;
        //console.log(icon);
        strengthIcon.classList.add('mdi');
        strengthIcon.classList.add(icon);
        // switch (res.availableNetworks[i].bars) {
        //     case 1:
        //     strengthIcon.classList.add('signal_wifi_'+res.availableNetworks[i].bars+'_bar'+ res.availableNetworks[i].encrypted == 'Secure'? '_lock' : '');
        //     break;
        //     case 2:
        //     strengthIcon.classList.add('material-icons', 'signal_wifi_2_bar');
        //     break;
        //     case 3:
        //     strengthIcon.classList.add('material-icons', 'signal_wifi_3_bar');
        //     break;
        //     case 4:
        //     strengthIcon.classList.add('material-icons', 'signal_wifi_4_bar')
        //     break;
        // }
        //console.log(res.availableNetworks[i].bars)
        strength.append(strengthIcon);
        ssidName = document.createElement('div');
        ssidName.classList.add('name', "wifi-name");
        ssidName.innerText = res.availableNetworks[i].ssid.slice(0,25) + (res.availableNetworks[i].ssid.length > 25 ? '...' : '') ;
        ssidName.title = res.availableNetworks[i].ssid;
        info = document.createElement('div');
        info.classList.add('info', 'loginEncryptionSuites');
        info.innerText = res.availableNetworks[i].displayedEncryptionSuites;
        // security = document.createElement('div');
        // security.classList.add('security');
        // securityIcon = document.createElement('i');
        // securityIcon.classList.add(res.availableNetworks[i].encrypted == 'Secure' ?  ["material-icons", "fa-lock"] : ["material-icons", "fa-unlock"])
        // security.append(securityIcon)
        main.append(strength);
        main.append(ssidName);
        main.append(info);
        wifiNetwork.append(main);
        //console.log(wifiNetwork);
        $('.wifi-items').append(wifiNetwork.outerHTML)
      }
    } else {
      $('.wifi-items').empty();
      wifiNetwork = document.createElement('div');
      wifiNetwork.classList.add("wifi-network");
      main = document.createElement('div');
      main.classList.add("main");
      main.innerText = "No Networks";
      wifiNetwork.append(main);
      $('.wifi-items').append(wifiNetwork.outerHTML)
    }
  });
}

$('#resetRouterPW').on('click', function(e) {
  $('#modalRouterPW').modal('show')
  $.getJSON(networkLoc + 'modules/resetrouterpw.cgi', function(response) {
    $('#modalRouterPW').modal('hide')
  })
})

$('body').click(function(event)
{
  // if(!$(event.target).closest('#saveButton').length && !$(event.target).is('#saveButton')) {
  //   $(".modal").hide();
  // }
});

function validateinputs(){
  var ssid = document.getElementById("routerSSID").value;
  var pass = document.getElementById("routerPW").value;

  if(ssid.includes(";") || pass.includes(";")) {
    console.log("dikembe");
    dikembe();
    return false;
  }
  else return true;

}

function dikembe(){
  document.getElementById("mutombo-modal").style.display = "block";

}

$('form[name="changeRouterPW').on('submit', function(e) {
  if(!validateinputs()) return false;
  e.preventDefault()
  $('#modalRouterPW').modal('show')
  var newPassword = $('#routerPW').val()
  var newSSID = $('#routerSSID').val()
  $.ajax({
    url: networkLoc + 'modules/changerouterpw.cgi',
    method: 'POST',
    data: { password: newPassword, SSID: newSSID },
    success: function(response) {
      $('#modalRouterPW').modal('hide')
      $('#routermsg').text('Updated.').effect("bounce", { times:3 }, 1200, function () {
        $('#routermsg').effect("fade", function () {
          $('#routermsg').text('');
        })
      });

    }
  })
})

function changeWifiStrength(num) {
  let strength = $('#connectedStrength').removeClass();
  strength.addClass('waveStrength-'+num)
}

$('form[name="login"]').on('submit', function(e) {
  var $save = $("#savelogin");
  var $cancel = $("#savelogin").next();
  $save.replaceWith($('<div id="savelogin" class="clearfix"><div class="spinner-border float-right"><span class="sr-only">Loading...</span></div></div>'));
  e.preventDefault()
  console.log(e.taget);
  var ssid = e.target.ssid.value
  var password = e.target.networkPW.value
  var bars = e.target.bars.value
  var connected = false;
  var encryptionSuites = e.target.encryptionSuites.value

  $.ajax({
    url: networkLoc + 'modules/login.cgi',
    method: 'POST',
    cache: false,
    data: { ssid: ssid, password: password, bars: bars, encrytionSuites: encryptionSuites },
    success: function(response) {
      $("#savelogin").replaceWith($('<button type="submit" id="savelogin" class="btn btn-primary next" disabled>Save</button>'))
      if(response.includes('Connection successfully')){
        $('#connected-wifi-network').text(ssid)
        changeWifiStrength(bars)
        $('#disconnectWifi').show()
        // implement error response if connection fails
        // if (res.error) {
        //   $('#modalNetworkPW').find('.alert').toggleClass('collapse').find('.message').text(res.error)
        //   $('#modalNetworkPW').find('#networkPW').focus()
        // } else {
        // hard-coded with 3em in mind where 1em == 16px
        // ideally get font size of parent container
        //$('#modalNetworkPW').find('.alert').toggleClass('collapse').find('.message').text('')
        $('input').val('')
        $('.row-wifi').show()
        $('#modalNetworkPW').modal('hide')
      } else {
        $("#wifiInfo").html("<span class='text-danger'>Invalid Password. </span>Try Again.")
        $('#connected-wifi-network').text('Not Connected');
        changeWifiStrength(0)
        $('#disconnectWifi').hide();
      }
      getNetwork();
      // }
    }
  })
})

$('#modalNetworkPW').on('shown.bs.modal', function(e) {
  $("#wifiInfo").html("Connecting may take a few seconds...")
  var $toggleNetworkPW = $('#toggleNetworkPW')
  $toggleNetworkPW.prop('checked', false)
  $(this).find('#networkPW').focus()
})

$('#modalNetworkPW').on('hidden.bs.modal', function(e) {
  var $toggleNetworkPW = $('#toggleNetworkPW')
  $('#networkPW').val('')
  if ($toggleNetworkPW.prop('checked')) {
    $toggleNetworkPW.prop('checked', false)
  }
  $('#modalNetworkPW').find('button[type="submit"]').prop('disabled', true)
})

// select available network to join
$('.wifi-items').on('click', 'a', function(e) {
  console.log(this, $(this).find('.wifi-name').text())
  var ssid = $(this).find('.wifi-name').text()

  // modal title ssid
  $('#modalNetworkPW').find('.ssid').text(ssid)

  // modal hidden ssid
  $('#modalNetworkPW').find('input[name="ssid"]').val(ssid)
  $('#modalNetworkPW').find('input[name="bars"]').val(bars)
  // modal hidden bars
  var bars = $(this).find('.mdi').data('bars')
  $('#modalNetworkPW').find('input[name="bars"]').val(bars)

  // modal hidden encryption suites
  var loginEncryptionSuites = $(this).find('.loginEncryptionSuites').text()
  $('#modalNetworkPW').find('input[name="encryptionSuites"]').val(loginEncryptionSuites)

  $('#modalNetworkPW').modal()
})

$('.banner .card-title').on('click', function(e) {
  var $this = $(this).closest('.banner')
  $this.siblings().slideToggle(0, function() {
    $(window).scrollTop($this.offset().top)
  })

  $this.find('.fa').toggleClass('fa-caret-right fa-caret-down')
})

$('#networkPW').on('input', function(e) {
  var $next = $(this).closest('.modal-content').find('.next')
  if (!$(this).val().length) {
    $next.prop('disabled', true)
  } else {
    $next.prop('disabled', false)
  }
})

var getNetworksTimeout = null

function sortNetworksByName(a, b) {
  if (a.ssid < b.ssid) return -1
  if (a.ssid > b.ssid) return 1
  return 0
}

function getAvailableNetworks2() {
  $.getJSON('/cgi-bin/modules/availablenetworks.cgi', function(response) {
    var availableNetworks = response.availableNetworks
    console.log(response)

    if (availableNetworks.length === 0) {
      showSpinner()
      return
    }

    // sort by name within same signal strength - strongest to weakest
    var bars4 = availableNetworks.filter(function(a) {
      return a.bars === 4
    }).sort(sortNetworksByName)

    var bars3 = availableNetworks.filter(function(a) {
      return a.bars === 3
    }).sort(sortNetworksByName)

    var bars2 = availableNetworks.filter(function(a) {
      return a.bars === 2
    }).sort(sortNetworksByName)

    var bars1 = availableNetworks.filter(function(a) {
      return a.bars === 1
    }).sort(sortNetworksByName)

    availableNetworks = bars4.concat(bars3, bars2, bars1)

    var html = ''

    // generate HTML for each available network
    var ii = 0
    for (var item of availableNetworks) {
      var displayedEncryptionSuites = item.displayedEncryptionSuites.map(a => a.toUpperCase()).join(', ')
      var loginEncryptionSuites = item.loginEncryptionSuites.join(',')

      html += `
      <li class="dropdown-item d-flex align-items-center">
      <div id="icon-${ii}" class="wifi-icon" data-bars=${item.bars}></div>
      <div class="wifi-info">
      <div class="wifi-name card-subtitle">${item.ssid}</div>
      <div>${item.encrypted} (${displayedEncryptionSuites})</div>
      <div class="d-none loginEncryptionSuites">${loginEncryptionSuites}</div>
      </div>
      </li>
      `

      ii++
    }

    // adding all list items at once prevents flickering
    $('.wifi-items').html(html)

    // now that list items are in the DOM, add the appropriate canvas to each
    $('.wifi-items li').each(function(index) {
      var $wifiIcon = $(this).find(`#icon-${index}`)
      var bars = $wifiIcon.data('bars')

      // hard-coded with 3em in mind where 1em == 16px
      // ideally get font size of parent container
      $wifiIcon.html(WifiIcon(bars, 64))
    })
  })

  getNetworksTimeout = setTimeout(getAvailableNetworks, 4000)
}

function showSpinner() {
  $('.wifi-items').html(`
    <div class="card" style="border:none">
    <div class="card-body p-3 d-flex justify-content-center">
    <span class="fa fa-spinner fa-pulse fa-3x fa-fw"></span>
    </div>
    </div>
    `)
  }
// $('.dropdown-toggle').dropdown({ "popperjs" : false })
  $('.dropdown').on('show.bs.dropdown', function() {
    showSpinner()
    getAvailableNetworks()
    console.log('getting networks');
  })

  $('.dropup').on('show.bs.dropdown', function() {
    showSpinner()
    getAvailableNetworks()
    console.log('getting networks');
  })

  $('.dropup').on('hide.bs.dropdown', function() {
    clearTimeout(getNetworksTimeout)
  })

  $('.dropdown').on('hide.bs.dropdown', function() {
    clearTimeout(getNetworksTimeout)
  })

  function getIpList() {
    $.getJSON(networkLoc + 'modules/iplist.cgi', function(response) {
      $('.wanip').text(response.wanip)
      $('.vpnip').text(response.vpnip)
      $('.4gip').text(response.fourgip)
      setTimeout(getIpList, 5000)
    })
  }

  function getLanConnections() {
    $.get(networkLoc + 'modules/lanconnections.cgi', function (devicesJson) {
      var devicesArray = Object.keys(devicesJson).map(function (device) {
        devicesJson[device].MAC = device;
        return devicesJson[device]
      });
      //console.log(devicesArray);
      $('[id=numConnectedDevices]').text(devicesArray.length);
      //$('[id=connectedDevicesList]').append('div').addClass('loading').attr('id', 'connectedDevicesListLoader');
      //console.log(devicesArray)
      devicesList = document.createElement('div');
      devicesArray.forEach( function (device) {
        //console.log(device.MAC);
        tr = document.createElement('tr');
        //tr.classList.add("media", "text-muted", "pt-3");
        iconwrap = document.createElement('th');
        iconwrap.scope = 'row';
        icon = document.createElement('img');
        //console.log(device.OS);
        try {
          OS  = JSON.stringify(device.OS);
          icon.src = '../imgs/device_icon.png';
          if (['MSFT', 'DESKTOP', 'Wistro'].indexOf(OS) > -1) icon.src = '../imgs/computer_icon.png';
          if (OS.includes('android')) icon.src = '../imgs/android_icon.png';
          if (OS.includes('ios')) icon.src = '../imgs/ios_icon.png';
        } catch {
          icon.src = '../imgs/device_icon.png';
        }
        icon.classList.add("mr-2", "rounded")
        icon.width = 32
        iconwrap.appendChild(icon);
        tr.appendChild(iconwrap);
        //row.classList.add("media-body", "pb-3", "mb-0", "small", "lh-125", "border-bottom", "border-gray")
        //innerRow.classList.add("d-flex", "justify-content-between", "align-items-center", "w-100");
        manufacturer = document.createElement('td');
        //manufacturer.classList.add("mx-5")
        manufacturer.innerText = device.Manufacturer;
        tr.appendChild(manufacturer);
        MAC = document.createElement('td');
        //MAC.classList.add("mx-5")
        MAC.innerText = device.MAC;
        tr.appendChild(MAC);
        clientHostName = document.createElement('td');
        //clientHostName.classList.add("mx-5")
        clientHostName.innerText = device['Client-Host-Name'];
        tr.appendChild(clientHostName);
        IPwrap = document.createElement('td');
        IP = document.createElement('a');
        //IP.classList.add("mx-5")
        IP.href = "http://" + device.IP;
        IP.innerText = device.IP;
        IPwrap.appendChild(IP);
        tr.appendChild(IPwrap);
        devicesList.appendChild(tr);
        /*<div class="media text-muted pt-3">
        <img data-src="holder.js/32x32?theme=thumb&amp;bg=007bff&amp;fg=007bff&amp;size=1" alt="32x32" class="mr-2 rounded" src="data:image/svg+xml;charset=UTF-8,%3Csvg%20width%3D%2232%22%20height%3D%2232%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%2032%2032%22%20preserveAspectRatio%3D%22none%22%3E%3Cdefs%3E%3Cstyle%20type%3D%22text%2Fcss%22%3E%23holder_1665ee4a6bb%20text%20%7B%20fill%3A%23007bff%3Bfont-weight%3Abold%3Bfont-family%3AArial%2C%20Helvetica%2C%20Open%20Sans%2C%20sans-serif%2C%20monospace%3Bfont-size%3A2pt%20%7D%20%3C%2Fstyle%3E%3C%2Fdefs%3E%3Cg%20id%3D%22holder_1665ee4a6bb%22%3E%3Crect%20width%3D%2232%22%20height%3D%2232%22%20fill%3D%22%23007bff%22%3E%3C%2Frect%3E%3Cg%3E%3Ctext%20x%3D%2211.546875%22%20y%3D%2216.9%22%3E32x32%3C%2Ftext%3E%3C%2Fg%3E%3C%2Fg%3E%3C%2Fsvg%3E" data-holder-rendered="true" style="width: 32px; height: 32px;">
        <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
        <div class="d-flex justify-content-between align-items-center w-100">
        <strong class="text-gray-dark">Full Name</strong>
        <a href="#">Follow</a>
        </div>
        <span class="d-block">@username</span>
        </div>
        </div>*/
      });
      //$('[id=connectedDevicesListLoader]').remove()
      $('[id=connectedDevicesList]').html(devicesList.innerHTML);
      //setTimeout(getLanConnections, 5000);
    })
    //devicesArray = [{"MAC":"00:10:18:0A:BD:CC", "IP":"192.168.123.115","Manufacturer":"Broadcom","Start-Time":" 2018-10-10 20:00:16","OS":"MSFT 5.0","Client-Host-Name":"TerraSLS-PC"},{"MAC": "00:0F:92:00:F9:05", "IP":"192.168.123.253","Manufacturer":"Microhard_Systems"}]
  }

  function getPing() {
    $.ajax({
      type: 'POST',
      url:networkLoc + 'modules/pingcheck.cgi',
      dataType:'JSON',
      data:{
      },
      success:function(response){
        document.getElementById("serversReachable").innerHTML = response.serversReachable + " of 3";
        document.getElementById("networkLatency").innerHTML = " in " + Math.round(response.rttavg) + " ms";

        var packetslost = 100 - (response.packetsReceived / 3) * 100;

        document.getElementById("packetLoss").innerHTML = Math.round(packetslost * 100)/100 + "%";
        $('serversReachable').text(response.serversReachable);
        setTimeout(getPing, 10000);
      },
      error:function(XMLHttpRequest, textStatus, error){
        console.log("failed: " + textStatus + ", " + error);
      }
    });
  }

  setTimeout(getPing, 3000)
  setTimeout(getIpList, 1500)
//  setTimeout(getLanConnections, 2000)


  $(function () {
    'use strict'

    $('[data-toggle="offcanvas"]').on('click', function () {
      $('.offcanvas-collapse').toggleClass('open')
    })
  })


  var c = document.createElement( 'canvas' ),
  ctx = c.getContext( '2d' ),
  rows = cols = 36,
  gap = 1,
  grays = [
    [ 26, 29 ],
    [ 32, 37 ],
    [ 42, 50 ],
    [ 46, 56 ],
    [ 54, 66 ]
  ],
  sizes = [ 4, 9, 14 ],
  frequency = [ false, 30, 9 ],
  cw = ch = c.width = c.height = ( sizes[ 0 ] + gap ) * rows;
  //grays = grays.map(function(x) {return x.map(function(y) {return y * 2})});

  function random( max, min ) {
    var min = min || 0;
    return Math.random() * ( max - min ) + min;
  }

  function cell( x, y, size ) {
    var gray = Math.floor( random( grays.length ) ),
    fill = grays[ gray ][ 0 ],
    stroke = grays[ gray ][ 1 ];
    ctx.fillStyle = 'rgb(' + fill + ', ' + fill + ', ' + fill + ')';
    ctx.strokeStyle = 'rgb(' + stroke + ', ' + stroke + ', ' + stroke + ')';
    ctx.fillRect( x, y, size, size );
    ctx.strokeRect( x + 0.5, y + 0.5, size - 1, size - 1 );
  }

  function generate() {
    var store = [];

    ctx.fillStyle = 'rgb(180, 180, 180)';
    ctx.fillRect( 0, 0, cw, ch );

    for( var x = 0; x < cols; x ++ ){
      for( var y = 0; y < rows; y ++ ){
        cell(
          ( x * sizes[ 0 ] ) + ( x * gap ),
          ( y * sizes[ 0 ] ) + ( y * gap ),
          sizes[ 0 ]
        );
      }
    }

    for( var freq = 0; freq < frequency.length; freq++ ) {
      if( frequency[ freq ] ){
        for( var i = 0; i < frequency[ freq ]; ) {
          var canDraw = true,
          sizeNew = sizes[ freq ],
          pad = Math.ceil( ( sizeNew / cw ) * rows );
          xNew = Math.floor( random( 1, cols - pad ) ) * ( ch / cols ),
          yNew = Math.floor( random( 1, rows - pad ) ) * ( cw / rows ),
          storeLength = store.length;
          if( storeLength ) {
            for( var j = 0; j < storeLength; j++ ) {
              var storeCell = store[ j ];
              if( !(
                xNew + sizeNew + ( cw / cols ) < storeCell.x ||
                yNew + sizeNew + ( ch / rows ) < storeCell.y ||
                xNew > storeCell.x + storeCell.size + ( cw / cols ) ||
                yNew > storeCell.y + storeCell.size + ( ch / rows )
              ) ) {
                canDraw = false;
                break;
              }
            }
          }
          if( canDraw ) {
            cell( xNew, yNew, sizeNew );
            store.push( { x: xNew, y: yNew, size: sizeNew } );
            i++;
          }
        }
      }
    }

    //document.getElementsByClassName('bg-blue')[0].style.background = 'url(' + c.toDataURL() + ')';
  }

  window.addEventListener( 'click', generate );
  generate();

  /*
  $.event.special.tripleclick = {

  setup: function(data, namespaces) {
  var elem = this, $elem = jQuery(elem);
  $elem.bind('click', jQuery.event.special.tripleclick.handler);
},

teardown: function(namespaces) {
var elem = this, $elem = jQuery(elem);
$elem.unbind('click', jQuery.event.special.tripleclick.handler)
},

handler: function(event) {
var elem = this, $elem = jQuery(elem), clicks = $elem.data('clicks') || 0;
clicks += 1;
if ( clicks === 3 ) {
clicks = 0;

// set event type to "tripleclick"
event.type = "tripleclick";

// let jQuery handle the triggering of "tripleclick" event handlers
jQuery.event.handle.apply(this, arguments)
}
$elem.data('clicks', clicks);
}

};

$('#waffles').bind("tripleclick", function () {
console.log('Waffles!')
})
*/
