/**
 * @params {number} bars - Signal strength 0 - 4
 * @params {number} size - width and height of canvas in pixels (default: body font size)
 * @returns {HTMLCanvasElement} canvas
 */

function WifiIcon(bars, size, colors) {
    size = size || parseInt(window.getComputedStyle(document.body).getPropertyValue('font-size'), 10)
    
    // handles string '4' vs number 4
    bars = typeof size === 'string' ? parseInt(bars, 10) : bars
    
    // handles string '16px' vs number 16
    size = typeof size === 'string' ? parseInt(size, 10) : size
    
    var canvas = document.createElement('canvas')
    var ctx = canvas.getContext('2d')  
    
    canvas.width = size
    canvas.height = size
    
    var colors = colors || {
      on: '#0f0',
      off: '#888'
    }
    
    var c = Math.PI * 2
    var lineWidth = size / 8
    
    for (var i = 0, j = 4; i < 4; i++, j--) {    
      var x = canvas.width
      var y = canvas.height
      var r = canvas.width - (lineWidth * i * 2) - lineWidth / 2
      
      ctx.beginPath()
      ctx.arc(x, y, r, c, false)
      ctx.lineWidth = lineWidth
      ctx.strokeStyle = bars >= j ? colors.on : colors.off
      ctx.stroke()
    }
    
    return canvas
  }