//witsWiz.js displays recived and sent wits data in tables
//MDF - 10/24/18
var pad = "0000"

async function getWITSWiz() {
  //reciveing & sending lists
  getWITSRec()
  getWITSSen()
  //all recived live data
  //{"1217":9566.0,"1222":0.0,"1224":0.0,"1225":0.0,"140":0.0,"108":9198.566,"141":48.0,"110":9198.566,"1204":117606.0,"1210":181024.0,"1211":175005.0,"123":90.0,"124":90.0,"1212":559.0,"125":90.0,"1213":2535.0,"1214":1943.0,"1215":674.0}
  function getWITSRec() {
    //console.log('Getting WITS recived...');
    $.get(endpoint + 'wits/witsIn', function (Res_witsRec) {
      let rec_ul = document.createElement('table');
      rec_ul.style.cssText = 'columns: 3; width: 100%; font-size: 16px; margin: 0 15px; display: table';
      rec_ul.id = "witsRec";
      let lastUpdate = new Date()
      $('.lastUpdate_Rec').text($.format.date(lastUpdate, 'dd-MMM-yyyy HH:mm:ss'));
      //Res_witsRec = {"1217":9566.0,"1222":0.0,"1224":0.0,"1225":0.0,"140":0.0,"108":9198.566,"141":48.0,"110":9198.566,"1204":117606.0,"1210":181024.0,"1211":175005.0,"123":90.0,"124":90.0,"1212":559.0,"125":90.0,"1213":2535.0,"1214":1943.0,"1215":674.0};
      //console.log($.isEmptyObject(Res_witsRec))
      if (!$.isEmptyObject(Res_witsRec)) {
        //console.log('Got WITS recived: ' + JSON.stringify(Res_witsRec).substr(0,30));
        Object.keys(Res_witsRec).forEach( function (witsRec, i) {
          if (i%3 == 0)
          row = rec_ul.insertRow(-1);
          let li = row.insertCell(i%3);
          li.style.cssText = 'list-style: none; display: table-cell; text-align: left;'; //may make a style sheet?
          li.innerText  = "0000".substring(0, "0000".length - witsRec.length) + witsRec  + ': ' + Number(Res_witsRec[witsRec]).toFixed(3);
          //rec_ul.appendChild(row);
        })
      } else {
        rec_ul = '<div style="padding-left: 40px;">No Data</div>';
      }
      $('#WITS-nav').show();
      $('#WITS-content').show();
      $('.loader-WITSWiz').hide();
      $('#Recived').html(rec_ul);
      setTimeout(getWITSRec, 2000);
    }).fail( function (Res_error) {
      console.warn("Could not get WITS recived from LinkBox: " + Res_error.status);
      setTimeout(getWITSRec, 15000);
    });
  }

  //all sending live data
  function getWITSSen() {
    //console.log('Getting WITS sent...');
    $.get(endpoint + 'wits/witsOut', function (Res_witsSen) {
      let sen_ul = document.createElement('table');
      sen_ul.style.cssText = 'columns: 3; width: 100%; font-size: 16px; margin: 0 15px; display: table';
      sen_ul.id = "witsSen";
      //Res_witsSen = {"1214":9566.0,"1222":0.0,"1224":0.0,"1225":0.0,"140":0.0,"108":9198.566,"141":48.0,"110":9198.566,"1204":117606.0,"1210":181024.0,"1211":175005.0,"123":90.0,"124":90.0,"1212":559.0,"125":90.0,"1213":2535.0,"1214":1943.0,"1215":674.0};
      let lastUpdate = new Date()
      $('.lastUpdate_Sen').text($.format.date(lastUpdate, 'dd-MMM-yyyy HH:mm:ss'));
      if (!$.isEmptyObject(Res_witsSen)) {
        //console.log('Got WITS sent: ' + JSON.stringify(Res_witsSen).substr(0,30));
        Object.keys(Res_witsSen).forEach( function (witsSen, i) {
          if (i%3 == 0)
          row = sen_ul.insertRow(-1);
          let li = row.insertCell(i%3);
          li.style.cssText = 'list-style: none; display: table-cell; text-align: left;'; //may make a style sheet?
          li.innerText  = pad.substring(0, pad.length - witsSen.length) + witsSen  + ': ' + Number(Res_witsSen[witsSen]).toFixed(3);
          //sen_ul.appendChild(li);
        })
      } else {
        sen_ul = '<div style="padding-left: 40px;">No Data</div>';
      }
      $('#WITS-nav').show();
      $('#WITS-content').show();
      $('.loader-WITSWiz').hide();
      $('#Sending').html(sen_ul);
      setTimeout(getWITSSen, 2000);
    }).fail( function (Res_error) {
      console.warn("Could not get WITS sent from LinkBox: " + Res_error.status);
      setTimeout(getWITSSen, 15000);
    });
  }



}
