#!/bin/ash

# Eric says Verizon 3G is 1.5Mbit/s down, 1Mbit/s up
# We tell HTB to use 75% of that in its calculations, and allow burstiness
#
# These speeds are used as kbps in the context below
UP3G=768
DOWN3G=1152
ETHERNET=7500
UPSLOW=100
DOWNSLOW=100

WAN=eth1
WWAN3G=3g-3G
BRLAN=br-lan

# Class & FWMARK description:
# 10 - to/from local LAN IPs & interfaces, includes MSILANIP0 & 1
# 11 - to/from MSI WAN IPs
# 13 - to/from anywhere else to/from 3G ==== SLOW ====
# 15 - no traffic should hit the default class

MSILANIP0=192.168.123.0/24
MSILANIP1=10.0.0.0/8
MSIWANIP1=198.243.4.232/29
MSIWANIP2=205.168.220.224/26
MSIWANIP3=216.241.103.64/27

# Set up IMQ device & use iptables to direct traffic to it
# echo -n "INIT: 1 "

# Make sure the connections are all properly tracked so we never send 
#  objectionable packets to Verizon
# 
# -A POSTROUTING -p tcp -m state --state RELATED,ESTABLISHED -j ACCEPT 
# -A FORWARD -p tcp -m state --state RELATED,ESTABLISHED -j ACCEPT

iptables -t filter -L FORWARD | grep RELATED 1>/dev/null 2>/dev/null || \
  iptables -t filter -I FORWARD -p tcp -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -t filter -L FORWARD | grep INVALID 1>/dev/null 2>/dev/null || \
  iptables -t filter -I FORWARD -p tcp -m state --state INVALID -j DROP
#iptables -t nat -L POSTROUTING | grep RELATED 1>/dev/null 2>/dev/null || \
#  iptables -t nat -I POSTROUTING -p tcp -m state --state RELATED,ESTABLISHED -j ACCEPT


if [ ! -f /tmp/.iptables-imq ] ; then {

iptables -t mangle -F Default 1>/dev/null 2>/dev/null
iptables -t mangle -X Default 1>/dev/null 2>/dev/null
iptables -t mangle -F Default_ct 1>/dev/null 2>/dev/null
iptables -t mangle -X Default_ct 1>/dev/null 2>/dev/null

iptables -t mangle -F PREROUTING
iptables -t mangle -F POSTROUTING

iptables -t mangle -A PREROUTING -i 3g-3G -j IMQ --todev 0
iptables -t mangle -A PREROUTING -i br-lan -j IMQ --todev 0

ifconfig imq0 up

touch /tmp/.iptables-imq

}
fi


# Set up kernel modules
# echo -n "2 "

insmod /lib/modules/2.6.32.27/sch_htb.ko 1>/dev/null 2>/dev/null
insmod /lib/modules/2.6.32.27/sch_sfq.ko 1>/dev/null 2>/dev/null
insmod /lib/modules/2.6.32.27/cls_fw.ko 1>/dev/null 2>/dev/null
insmod /lib/modules/2.6.32.27/cls_u32.ko 1>/dev/null 2>/dev/null

# Set up QDISCs
# echo -n "3 "

tc qdisc del root dev ${WWAN3G} 1>/dev/null 2>/dev/null
tc qdisc del root dev ${BRLAN} 1>/dev/null 2>/dev/null
tc qdisc del dev imq0 root 1>/dev/null 2>/dev/null
tc qdisc del dev eth1 root 1>/dev/null 2>/dev/null

#
# System architecture: IMQ device allows bidirectional shaping.
#  Use u32 classifier because the fwmark classifier didn't work as expected.

tc qdisc add dev imq0 root handle 1: htb default 15    
tc class add dev imq0 parent 1: classid 1:1 htb rate ${UP3G}kbit ceil ${UP3G}kbit
tc class add dev imq0 parent 1: classid 1:2 htb rate ${DOWN3G}kbit ceil ${DOWN3G}kbit
tc class add dev imq0 parent 1: classid 1:3 htb rate ${ETHERNET}kbit ceil ${ETHERNET}kbit

tc class add dev imq0 parent 1:1 classid 1:10 htb rate ${UP3G}kbit ceil ${UP3G}kbit prio 1
tc class add dev imq0 parent 1:1 classid 1:11 htb rate ${UP3G}kbit ceil ${UP3G}kbit prio 2

if [ -f /tmp/.slowmedown ] ; then {
tc class add dev imq0 parent 1:1 classid 1:13 htb rate ${UPSLOW}kbit ceil ${UPSLOW}kbit prio 3
tc class add dev imq0 parent 1:1 classid 1:15 htb rate ${UPSLOW}kbit ceil ${UPSLOW}kbit prio 4
     }
else {
tc class add dev imq0 parent 1:1 classid 1:13 htb rate ${UP3G}kbit ceil ${UP3G}kbit prio 3
tc class add dev imq0 parent 1:1 classid 1:15 htb rate ${UP3G}kbit ceil ${UP3G}kbit prio 4
     }
fi

tc class add dev imq0 parent 1:2 classid 1:20 htb rate ${DOWN3G}kbit ceil ${DOWN3G}kbit prio 1
tc class add dev imq0 parent 1:2 classid 1:21 htb rate ${DOWN3G}kbit ceil ${DOWN3G}kbit prio 2

if [ -f /tmp/.slowmedown ] ; then {
tc class add dev imq0 parent 1:2 classid 1:23 htb rate ${DOWNSLOW}kbit ceil ${DOWNSLOW}kbit prio 3
tc class add dev imq0 parent 1:2 classid 1:25 htb rate ${DOWNSLOW}kbit ceil ${DOWNSLOW}kbit prio 4
     }
else {
tc class add dev imq0 parent 1:2 classid 1:23 htb rate ${DOWN3G}kbit ceil ${DOWN3G}kbit prio 3
tc class add dev imq0 parent 1:2 classid 1:25 htb rate ${DOWN3G}kbit ceil ${DOWN3G}kbit prio 4
     }
fi

tc class add dev imq0 parent 1:3 classid 1:30 htb rate ${ETHERNET}kbit ceil ${ETHERNET}kbit prio 1
tc class add dev imq0 parent 1:3 classid 1:31 htb rate ${ETHERNET}kbit ceil ${ETHERNET}kbit prio 2


# Set up u32 classifier to classify the traffic into various flowids
# echo -n "4 "

# To AND From LAN/VPN IPs - local traffic only
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSILANIP0} match ip dst ${MSILANIP0} flowid 1:31
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSILANIP1} match ip dst ${MSILANIP1} flowid 1:31

# Not sure if this kind of traffic ever happens but if so it can be fast
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSILANIP0} match ip dst ${MSILANIP1} flowid 1:31
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSILANIP1} match ip dst ${MSILANIP0} flowid 1:31

# echo -n "5 "

# DNS need sto be fast regardless of bandwidth cap, so that MSI stuff works as expected
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip sport 53 0xffff flowid 1:31
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip dport 53 0xffff flowid 1:31

# echo -n "6 "

# MSI IPs are fast regardless of bandwidth cap
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip dst ${MSIWANIP1} flowid 1:11
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSIWANIP1} flowid 1:21
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip dst ${MSIWANIP2} flowid 1:11
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSIWANIP2} flowid 1:21
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip dst ${MSIWANIP3} flowid 1:11
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip src ${MSIWANIP3} flowid 1:21

# echo -n "7 "

#For some dumb reason this conflicts with the rules above and overrides ip dst $MSIWANIP
# So don't do it, even if it seems like a good idea and we need it.
#tc filter add dev imq0 parent 1: protocol ip u32 \
#    match ip src ${MSILANIP0} flowid 1:13
#Allow fast downloads.
tc filter add dev imq0 parent 1: protocol ip u32 \
    match ip dst ${MSILANIP0} flowid 1:23

# All unclassified traffic is caught by the default, I think 1:15
# 1:15 is slow or fast depending on bandwidth cap

# echo "DONE."

