#!/bin/sh

WAN=eth1
INTERFACE=3g-3G
CAP=GiB
# FOR DEBUGGING: CAP=MiB
# CAP=MiB

# This shell script applies a bandwidth cap of 1GB per week to the 3g interface.
# If the default gateway is the WAN interface (eth1) then it does not apply any bandwidth cap.
# BUG: If the system date is wrong or the time goes back, then the bandwidth stats will not be right nor will they update.

# EXAMPLE OUTPUT:
# root@OpenWrt:/bin# /usr/bin/vnstat -w -i 3g-3G | grep "current week"
#   current week      2.30 MiB |     448 KiB |    2.74 MiB |    0.28 kbit/s
# We allow 1GB per week so the current week can never exceed 1GB, if it does
#  then the text GiB will appear in the vnstat output.

# Potential bug: there had better not be TWO default routes in the routing table, if
#  there are, then this next line might behave unpredictably.
netstat -rn | grep ^0.0.0.0 | awk '{print $NF}' | grep eth1 1>/dev/null 2>/dev/null || {

# This section is only run is the default gateway is NOT eth1.
# MANUAL OVERRIDE

if [ -f /tmp/OVERRIDE3G ] ; then {

if [ ! -f /tmp/.OVERRIDE3G ] ; then {

# echo OVERRIDE3G
 touch /tmp/.OVERRIDE3G
 rm -f /tmp/.slowmedown
 rm -f /tmp/.fast3G
 rm -f /tmp/.fastWAN
 /usr/bin/bandwidth.sh

}
fi

exit
}
fi

# If we get to this point, then there is no manual override and the default gateway should be 3G

/usr/bin/vnstat -w -i ${INTERFACE} | grep "current week" | grep ${CAP} 1>/dev/null 2>/dev/null && {

if [ ! -f /tmp/.slowmedown ] ; then {

# echo SLOW-3G
 touch /tmp/.slowmedown
 rm -f /tmp/.OVERRIDE3G
 rm -f /tmp/.fast3G
 rm -f /tmp/.fastWAN
 /usr/bin/bandwidth.sh
                                    }
fi

 exit
}

if [ ! -f /tmp/.fast3G ] ; then {

# echo FAST-3G
 touch /tmp/.fast3G
 rm -f /tmp/.OVERRIDE3G
 rm -f /tmp/.slowmedown
 rm -f /tmp/.fastWAN
 /usr/bin/bandwidth.sh

}
fi

exit
}

# If we get to this point, it is because we skipped all the logic above.
# The default gateway must be eth1, therefore remove the bandwidth cap.

if [ ! -f /tmp/.fastWAN ] ; then {

# echo FAST-WAN
 touch /tmp/.fastWAN
 rm -f /tmp/.OVERRIDE3G
 rm -f /tmp/.slowmedown
 rm -f /tmp/.fast3G
 /usr/bin/bandwidth.sh

}
fi
