#!/bin/bash

WAN=eth1
INTERFACE=3g-3G
ALLOWED=1
CAP=GiB
# FOR DEBUGGING: CAP=MiB
# CAP=MiB
# ALLOWED is the integer number of GB allowed before we apply the snail-speed bandwidth cap.
#  Setting ALLOWED to 1 means that they can use up to 1.9GB at the 100Kbps bandwidth cap.
#  At 2.0GB or greater, then they get the 10Kbps bandwidth cap.

# This shell script applies a bandwidth cap of 1GB per week to the 3g interface.
# If the default gateway is the WAN interface (eth1) then it does not apply any bandwidth cap.
# BUG: If the system date is wrong or the time goes back, then the bandwidth stats will not be right nor will they update.

# EXAMPLE OUTPUT:
# root@OpenWrt:/bin# /usr/bin/vnstat -w -i 3g-3G | grep "current week"
#   current week      2.30 MiB |     448 KiB |    2.74 MiB |    0.28 kbit/s
# We allow 1GB per week so the current week can never exceed 1GB, if it does
#  then the text GiB will appear in the vnstat output.

# Potential bug: there had better not be TWO default routes in the routing table, if
#  there are, then this next line might behave unpredictably.
netstat -rn | grep ^0.0.0.0 | awk '{print $NF}' | grep eth1 1>/dev/null 2>/dev/null || {

 #echo "Default route is not on eth1"

 # This section is only run is the default gateway is NOT eth1.
 # MANUAL OVERRIDE

 if [ -f /tmp/OVERRIDE3G ] ; then {

  if [ ! -f /tmp/.OVERRIDE3G ] ; then {

    #echo OVERRIDE3G
    touch /tmp/.OVERRIDE3G
    rm -f /tmp/.slowmedown
    rm -f /tmp/.fast3G
    rm -f /tmp/.fastWAN
    rm -f /tmp/.whoaNelly
    /usr/bin/bandwidth.sh

    }
  fi

  exit
 }
 fi

 # If we get to this point, then there is no manual override and the default gateway should be 3G
 # Check for bandwidth over-age.

 /usr/bin/vnstat -w -i ${INTERFACE} | grep "current week" | grep ${CAP} 1>/dev/null 2>/dev/null && {
 # Bandwidth hogs used at least 1GB of data

   TOTAL=`vnstat -w -i 3g-3G | grep "current week" | awk -F\| '{print $3}' | awk '{print $1}' | awk -F. '{print $1}'`
   #echo TOTAL is $TOTAL
   # Comparison operators: -lt -le -gt -ge

   if [ $TOTAL -le $ALLOWED ] ; then {
   # Compares the integer part of the bandwidth usage

    if [ ! -f /tmp/.slowmedown ] ; then {

    #echo SLOW-3G
    touch /tmp/.slowmedown
    rm -f /tmp/.OVERRIDE3G
    rm -f /tmp/.fast3G
    rm -f /tmp/.fastWAN
    rm -f /tmp/.whoaNelly
    /usr/bin/bandwidth.sh

    }
    fi

    #echo SET TO SLOW-3G, EXITING
    exit

   }
   elif [ $TOTAL -gt $ALLOWED ] ; then {
   # Compares the integer part of the bandwidth usage

    if [ ! -f /tmp/.whoaNelly ] ; then {

    #echo WHOA, NELLY!
    touch /tmp/.whoaNelly
    rm -f /tmp/.OVERRIDE3G
    rm -f /tmp/.slowmedown
    rm -f /tmp/.fastWAN
    rm -f /tmp/.fast3G
    /usr/bin/bandwidth.sh

    }
    fi

    #echo SET TO SNAIL-3G, EXITING
    exit

   }

   fi # end of the TOTAL bandwidth usage check

  } # end of bandwidth cap found/required

  #If we got here we are on 3G and didn't need a bandwidth cap
  #echo 3G, NO BANDWIDTH CAP REQUIRED

  if [ ! -f /tmp/.fast3G ] ; then {

    #echo FAST-3G
    touch /tmp/.fast3G
    rm -f /tmp/.OVERRIDE3G
    rm -f /tmp/.slowmedown
    rm -f /tmp/.fastWAN
    rm -f /tmp/.whoaNelly
    /usr/bin/bandwidth.sh

    }
  fi

  #echo SET TO FAST3G, EXITING

  exit

} # end of default route on 3G (not on eth1, really)


# If we get to this point, it is because we skipped the 3G logic above.
# The default gateway must be eth1, therefore remove the bandwidth cap.

if [ ! -f /tmp/.fastWAN ] ; then {

#echo FAST-WAN
 touch /tmp/.fastWAN
 rm -f /tmp/.OVERRIDE3G
 rm -f /tmp/.slowmedown
 rm -f /tmp/.fast3G
 rm -f /tmp/.whoaNelly
 /usr/bin/bandwidth.sh

}
fi

#echo SET TO FASTWAN, EXITING
