#!/usr/bin/php-cgi
<!DOCTYPE html>
	<head>
		<meta charset="utf-8">
		<title>MSI Router Bandwidth Usage</title>
		<link rel="shortcut icon" href="/favicon.ico" />
		<!--[if lt IE 9]> 
 			<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script> 
		<![endif]-->
		<link href="/css/reset.css" rel="stylesheet" type="text/css" />
		<link href="/css/main.css" rel="stylesheet" type="text/css" />
		<script type="text/javascript" src="/js/browserCSSdetector.js"></script>
		<?php if (preg_match ( "/192.169.123/", $_SERVER['REMOTE_ADDR'])) {
			print "<script language=\"javascript\" src=\"/js/jquery-1.7.1.min.js\"></script>";
		}
		else {
			print "<script language=\"javascript\" src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js\"></script>";
		} ?>

	</head>
	<body>
		<a href="#"><img src="/images/logo.gif" class="logo" /></a>

<?php printf("%s",$result); ?>

<?php
if (isset($_GET["provider"])) {
  $preferredProvider = shell_exec("uci get preferredprovider.@preferred[0].provider");
  if (strcmp(trim($preferredProvider), trim($_GET["provider"]))) {
    $setnewpref = "/usr/bin/preferredupdate.sh ".$_GET["provider"];
    shell_exec($setnewpref);
  }
}
?>

		<section class="frame">
			<div class="provider">Current Provider: <?php $currentprovider = shell_exec("ls -la /etc/config/network | cut -d . -f 2"); if (preg_match("/verizon/", $currentprovider)) { print "<img id=\"currentprovider\" src=\"/data/provider_logo_verizon.jpg\" />"; } else if (preg_match("/att/", $currentprovider)) { print "<img id=\"currentprovider\" src=\"/data/provider_logo_att.png\" />"; } ?></div>
			<div class="deviceName"><?php print shell_exec("cat /etc/ML-BOX"); ?> Router Info</div>
			<div class="info">
				<h1>BANDWIDTH USAGE <i>(Weekly)</i></h1>
				<div class="statusbar">
					<div class="holder">
<?php
$bucketusage = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 1");
$bucketprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 3 | sed 's/^ *//g' | cut -d ' ' -f 2");
$rxtotal = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$txtotal = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 1");
$rxprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 1 | cut -d \k -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
$txprefix = shell_exec("vnstat -w -i 3g-3G | grep -v last | grep -v estimated | grep current | cut -d \| -f 2 | sed 's/^ *//g' | cut -d ' ' -f 2");
if (preg_match ( "/MiB/", $bucketprefix)) {
  if ($bucketusage <= 1024) {
    $buckettotalusage = $bucketusage / 1024;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = 0;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / $bucketusage;
    } else {
      $bucketrx = 0;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / $bucketusage;
    } else {
      $buckettx = 0;
    }
  }
}
else if (preg_match ( "/GiB/", $bucketprefix)) {
  if ($bucketusage <= 1) {
    $buckettotalusage = $bucketusage;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal;
    }
  }
  else {
    $buckettotalusage = 1;
    if (preg_match ( "/MiB/", $rxprefix)) {
      $bucketrx = $rxtotal / 1024;
    } else {
      $bucketrx = $rxtotal / $bucketusage;
    }
    if (preg_match ( "/MiB/", $txprefix)) {
      $buckettx = $txtotal / 1024;
    } else {
      $buckettx = $txtotal / $bucketusage;
    }
  }
}
else if (preg_match ( "/KiB/", $bucketprefix)) {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}
else {
  $buckettotalusage = 0;
  $bucketrx = 0;
  $buckettx = 0;
}

print "<span id=\"a\"><div class=\"a\" style=\"width: ".round(bucketrx*100,0)."%\"><b>rx</b></div></span>";
print "<span id=\"b\"><div class=\"b\" style=\"width: ".round(buckettx*100,0)."%\"><b>tx</b></div></span>";
					print "</div>";
					print "<span class=\"counter\" id=\"counter\">";
					print "Total: ".round(bucket*1024,0)." MB | ".(1024-round(bucket*1024,0))." MB remaining";
?>
					</span><br>
				</div>
			</div>
			<div class="status">
				<h1>CONNECTION STATUS</h1>
				<div class="selector">
					Current 3G Network swapping: <span class="violet"><?php $preferredProvider = shell_exec("uci get preferredprovider.@preferred[0].provider"); if (preg_match("/att/", $preferredProvider)) { print "AT&T only"; } if (preg_match("/verizon/", $preferredProvider)) { print "Verizon only"; } if (preg_match("/automatic/", $preferredProvider)) { print "Automatic"; } ?></span><br>
					<?php
						print "<form name=\"preferred\" action=\"bandwidth.cgi\" method=\"get\">";
						print "Preferred 3G Network usage: <select name='provider' onchange='submitProvider()'>";
						if (preg_match("/automatic/", $preferredProvider)) {
							print "<option value=\"automatic\" selected=\"selected\">Automatic</option>";
						}
						else {
							print "<option value=\"automatic\">Automatic</option>";
						}
						system("cat /proc/tty/driver/usbserial | grep product:683c 1>/dev/null 2>/dev/null", $retval);
						if ( $retval == "0" ) {
							if (preg_match("/att/", $preferredProvider)) {
								print "<option value=\"att\" selected=\"selected\">AT&T Only</option>";
							}
							else {
								print "<option value=\"att\">AT&T Only</option>";
							}
						}
						system("cat /proc/tty/driver/usbserial | grep product:0028 1>/dev/null 2>/dev/null", $retval);
						if ( $retval == "0" ) {
							if (preg_match("/verizon/", $preferredProvider)) {
								print "<option value=\"verizon\" selected=\"selected\">Verizon Only</option>";
							}
							else {
								print "<option value=\"verizon\">Verizon Only</option>";
							}
						}
						print "</select>";
						print "<noscript><input type=\"submit\" value=\"Submit\"></noscript>";
						print "</form>\n";

						if (file_exists('/tmp/pingcheck.txt')) {
							$pingOutput = file('/tmp/pingcheck.txt');
							$pingMetrics = explode(" ", $pingOutput[0]);

							print "<br>MSI Servers Reachable: <font color=\"green\"><span id=\"reachable\">".$pingMetrics[0]."/3 ".round($pingMetrics[0]/3*100)."%</span></font>";
							print "<br>Network Latency: <font color=\"green\">rtt <span id=\"rtt\">".$pingMetrics[1]."</span> ms, mdev <span id=\"mdev\">".$pingMetrics[2]."</span> ms</font>";
							print "<br>Packet Loss: <font color=\"green\"><span id=\"loss\">".trim($pingMetrics[3])."</span>%</font>";
						} else {
							print "<br>MSI Servers Reachable: <font color=\"green\"><span id=\"reachable\"></span></font>";
                                                        print "<br>Network Latency: <font color=\"green\">rtt <span id=\"rtt\"></span> ms, mdev <span id=\"mdev\"></span> ms</font>";
                                                        print "<br>Packet Loss: <font color=\"green\"><span id=\"loss\"></span>%</font>";
						}
						?>
				</div>
				<ul class="informer">
<?php
$verizonoutput = file("/tmp/verizonmetrics");
$verizonrssi = explode("\n", $verizonoutput[0]);
$verizonroaming = explode("\n", $verizonoutput[1]);
$attOutput = file('/tmp/attmetrics');
$attrssi = explode("\n", $attOutput[0]);
$attroaming = explode("\n", $attOutput[1]);

					print "<li>";
if ($attrssi[0] >= -76 && $attrssi[0] < 0) { print "<img id=\"attbars\" src=\"/images/Grey-Bar-5.png\" />"; }
else if ($attrssi[0] >= -82 && $attrssi[0] < 0) { print "<img id=\"attbars\" src=\"/images/Grey-Bar-4.png\" />"; }
else if ($attrssi[0] >= -94 && $attrssi[0] < 0) { print "<img id=\"attbars\" src=\"/images/Grey-Bar-3.png\" />"; }
else if ($attrssi[0] >= -105 && $attrssi[0] < 0) { print "<img id=\"attbars\" src=\"/images/Grey-Bar-2.png\" />"; }
else if ($attrssi[0] >= -111 && $attrssi[0] < 0) { print "<img id=\"attbars\" src=\"/images/Grey-Bar-1.png\" />"; }
else { print "<img id=\"attbars\" src=\"/images/Grey-Bar-0.png\" />"; }

					print "AT&T RSSI: <span id=\"attrssi\" class=\"violet\">".$attrssi[0]."</span> - ";
					if ($attroaming[0] == 0) { print "<span id=\"attroaming\">Not roaming</span></li>"; } else if ($attroaming[0] == 1) { print "<span id=\"attroaming\">Roaming</span></li>"; } else { print "<span id=\"attroaming\">Unknown roaming</span></li>"; }
					print "<li>";
if ($verizonrssi[0] >= -76 && $verizonrssi[0] < 0) { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-5.png\" />"; }
else if ($verizonrssi[0] >= -88 && $verizonrssi[0] < 0) { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-4.png\" />"; }
else if ($verizonrssi[0] >= -98 && $verizonrssi[0] < 0) { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-3.png\" />"; }
else if ($verizonrssi[0] >= -107 && $verizonrssi[0] < 0) { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-2.png\" />"; }
else if ($verizonrssi[0] >= -124 && $verizonrssi[0] < 0) { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-1.png\" />"; }
else { print "<img id=\"verizonbars\" src=\"/images/Grey-Bar-0.png\" />"; }

					print "Verizon RSSI: <span id=\"verizonrssi\" class=\"violet\">".$verizonrssi[0]."</span> - ";
					if ($verizonroaming[0] == 0) { print "<span id=\"verizonroaming\">Not roaming</span></li>"; } else if ($verizonroaming[0] >= 1) { print "<span id=\"verizonroaming\"Roaming</span></li>"; } else { print "<span id=\"verizonroaming\">Unknown roaming</span></li>"; }

?>
				</ul>
			</div>
			<div class="separator"></div>
			<div class="about">
				<p>Capped Status: <span id="cappedStatus"><?php if (file_exists("/tmp/.slowmedown")) {print "100 kB/s Bandwidth cap is in effect."; } else if (file_exists("/tmp/.whoaNelly")) {print "10 kB/s Bandwidth cap is in effect."; } else { print "NO bandwidth cap is in effect."; } ?></span><br> 
				Router Time: <span id="clocktime"><?php trim(system("date")) ?></span><br>US Mountain Time: <span id="mountaintime"><?php
#trim(system("date")) #old system call, shows UTC only
$routertime=chop(shell_exec("date"));

$UTCTZ = new DateTimeZone('UTC');
$MNTTZ = new DateTimeZone('America/Denver');

$dt = new DateTime($routertime, $UTCTZ);
$dt->setTimezone($MNTTZ);
$mountaintime=$dt->format(DATE_RFC822);
$unixtimestamp=$dt->format('U');
print nl2br("$mountaintime");
?></span></p>
<?php
$last_line = system("ifconfig 3g-3G | grep -i inet 1>/dev/null 2>/dev/null", $retval);
print "<p>Connection Status: ";
if ( $retval == "0" ) {
   print "<span id = \"connectioninfo\"><FONT COLOR=\"green\">3G cellular connection appears to be up.</FONT></span>\n<BR>";
   print "<span id = \"redialingstatus\"></span>";
   $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i 3G 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     print "Internet Status: <span id = \"internetstatus\">Using 3G data connection for all internet traffic.</span>\n<BR>";
   }
   else {
     $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
     if ( $retval == "0" ) {
       print "Internet Status: <span id = \"internetstatus\">Using WAN data connection for internet traffic.</span>\n<BR>";
     }
     else {
       print "Internet Status: <span id = \"internetstatus\">No internet connection found.</span>\n<BR>";
     }
   }
   print "<span id = \"connectionmetrics\">";
   $last_line = system("ifconfig 3g-3G | grep -i inet", $retval);
   print "</span>";
}
else
{
   print "<span id = \"connectioninfo\"><FONT COLOR=\"red\">3G cellular connection appears to be down.</FONT></span>\n<BR>";
   $last_line = system("logread | grep pppd  1>/dev/null 2>/dev/null", $retval);
   print "Redialing status: ";
   if ( $retval == "0" ) {
     print "<span id = \"redialingstatus\">Redialing in progress.</span>\n<BR>";
   }
   else {
     print "<span id = \"redialingstatus\">Redialing is apparently not in progress...</span>\n<BR>";
   }
   $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i 3G 1>/dev/null 2>/dev/null", $retval);
   if ( $retval == "0" ) {
     print "Internet Status: <span id = \"internetstatus\">Using 3G data connection for all internet traffic.</span>\n<BR>";
   }
   else {
     $last_line = system("netstat -rn | grep ^0.0.0.0 | grep -i eth1 1>/dev/null 2>/dev/null", $retval);
     if ( $retval == "0" ) {
       print "Internet Status: <span id = \"internetstatus\">Using WAN data connection for internet traffic.</span>\n<BR>";
     }
     else {
       print "Internet Status: <span id = \"internetstatus\">No internet connection found.</span>\n<BR>";
     }
   }

   print "<span id = \"connectionmetrics\"></span>";
}
print "</p>";
?>
				<p>Please note: Bandwidth usage is tracked only on the 3G cellular connection.<br> This data plan allows 1GB per week (current week), and is throttled beyond that.<br>
				<p>Router Software Version <?php echo shell_exec("cat /etc/ROUTER-VERSION"); ?></p>
			</div>
		</section>
<?php
# The bandwidth cap can be overridden manually
#  Enable the override: GET /cgi-bin/bandwidth.cgi?override=1
#  Disable the override & restore defaults: GET /cgi-bin/bandwidth.cgi?override=0

$setoverride="touch /tmp/OVERRIDE3G";
$unsetoverride="rm -f /tmp/OVERRIDE3G";
$bandwidthcmd="/bin/ash /usr/bin/bandwidthcap.sh";

if ($_GET["override"] == "1") {
  system("$setoverride");
  system("$bandwidthcmd");
  print "<FONT COLOR=\"GREEN\"><H2>OVERRIDING BANDWIDTH CAP - full 3G bandwidth will be available.</FONT></H2><BR>";
}
else if ($_GET["override"] == "0") {
  system("$unsetoverride");
  print "<FONT COLOR=\"GREEN\"><H2>RESTORING NORMAL BANDWIDTH CAP FUNCTION - 1GiB/week limit.</FONT></H2><BR>";
  system("$bandwidthcmd");
}



print "<script language=\"javascript\">";

print "updateMetrics();";
if (preg_match ( "/192.168.123/", $remoteAddr)) {
print "var int=self.setInterval(\"updateMetrics()\", 4000);";
}
else {
print "var int=self.setInterval(\"updateMetrics()\", 60000);";
}
print "function updateMetrics() {";
print "$.getJSON(\"/cgi-bin/metrics.cgi\", function(json) {\n";
print "if (!document.getElementById(\"currentprovider\").src.indexOf(json.currentprovider)) {document.getElementById(\"currentprovider\").src = \"/data/provider_logo_\"+json.currentProvider+\".png\";}\n";

print "document.getElementById(\"a\").innerHTML = \"<div class='a' style='width: \"+Math.round(json.bucketrx*100)+\"%'><b>rx</b></div>\";\n";
print "document.getElementById(\"b\").innerHTML = \"<div class='b' style='width: \"+Math.round(json.buckettx*100)+\"%'><b>tx</b></div>\";\n";
print "if (Math.round(json.bucket*1024) < 1024) {";
print "document.getElementById(\"counter\").innerHTML = \"Total: \"+Math.round(json.bucket*1024)+\" MB | \"+(1024-Math.round(json.bucket*1024))+\" MB remaining\";\n";
print "} else {";
print "document.getElementById(\"counter\").innerHTML = \"Total: \"+json.bucketactual+\" \"+ json.bucketprefix +\" | \"+(1024-Math.round(json.bucket*1024))+\" MB remaining\";\n";
print "}";
print "if (json.cards[1].rssi >= -76 && json.cards[1].rssi < 0) {if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-5.png\")) { document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-5.png\"; }}\n";
print "else if (json.cards[1].rssi >= -88 && json.cards[1].rssi < 0) {if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-4.png\")) { document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-4.png\"; }}\n";
print "else if (json.cards[1].rssi >= -98 && json.cards[1].rssi < 0) {if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-3.png\")) { document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-3.png\"; }}\n";
print "else if (json.cards[1].rssi >= -107 && json.cards[1].rssi < 0) {if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-2.png\")) { document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-2.png\"; }}\n";
print "else if (json.cards[1].rssi >= -124 && json.cards[1].rssi < 0) {if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-1.png\")) { document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-1.png\"; }}\n";
print "else if (!document.getElementById(\"verizonbars\").src.indexOf(\"Grey-Bar-0.png\")) {document.getElementById(\"verizonbars\").src = \"/images/Grey-Bar-0.png\"; }\n";

print "if (json.cards[1].rssi < 0) { document.getElementById(\"verizonrssi\").innerHTML = json.cards[1].rssi; }";
print "else { document.getElementById(\"verizonrssi\").innerHTML = \" UNAVAILABLE\"; }";

print "if (json.cards[1].roamingstatus == 0) { document.getElementById(\"verizonroaming\").innerHTML = \"Not roaming\"; }";
print "else if (json.cards[1].roamingstatus == 1) { document.getElementById(\"verizonroaming\").innerHTML = \"Roaming with SIDs\"; }";
print "else if (json.cards[1].roamingstatus == 2) { document.getElementById(\"verizonroaming\").innerHTML = \"Roaming without SIDs\"; }";
print "else if (json.cards[1].roamingstatus > 2) { document.getElementById(\"verizonroaming\").innerHTML = \"Roaming\"; }";
print "else { document.getElementById(\"verizonroaming\").innerHTML = \"Unknown roaming\"; }";

print "if (json.cards[0].rssi >= -76 && json.cards[0].rssi < 0) {if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-5.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-5.png\"; }}";
print "else if (json.cards[0].rssi >= -82 && json.cards[0].rssi < 0) {if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-4.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-4.png\"; }}";
print "else if (json.cards[0].rssi >= -94 && json.cards[0].rssi < 0) {if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-3.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-3.png\"; }}";
print "else if (json.cards[0].rssi >= -105 && json.cards[0].rssi < 0) {if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-2.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-2.png\"; }}";
print "else if (json.cards[0].rssi >= -111 && json.cards[0].rssi < 0) {if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-1.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-1.png\"; }}";
print "else if (!document.getElementById(\"attbars\").src.indexOf(\"Grey-Bar-0.png\")) { document.getElementById(\"attbars\").src = \"/images/Grey-Bar-0.png\"; }";

print "if (json.cards[0].rssi < 0) { document.getElementById(\"attrssi\").innerHTML = json.cards[0].rssi; }";
print "else { document.getElementById(\"attrssi\").innerHTML = \"UNAVAILABLE\"; }";

print "if (json.cards[0].roamingstatus == 0) { document.getElementById(\"attroaming\").innerHTML = \"Not roaming\"; }";
print "else if (json.cards[0].roamingstatus == 1) { document.getElementById(\"attroaming\").innerHTML = \"Roaming\"; }";
print "else { document.getElementById(\"attroaming\").innerHTML = \"Unknown roaming\"; }";

print "if (json.pingArray.reachable != null) {";
print "document.getElementById(\"reachable\").innerHTML = json.pingArray.reachable+\"/3 \"+Math.round(json.pingArray.reachable/3*100)+\"%\";";
print "document.getElementById(\"rtt\").innerHTML = json.pingArray.rtt;";
print "document.getElementById(\"mdev\").innerHTML = json.pingArray.mdev;";
print "document.getElementById(\"loss\").innerHTML = json.pingArray.loss;";
print "}";

print "if (json.bandwidthcap == 1) { document.getElementById(\"cappedStatus\").innerHTML = \"100 kB/s Bandwidth cap is in effect.\"; }\n"; 
print "else if (json.bandwidthcap == 2) { document.getElementById(\"cappedStatus\").innerHTML = \"10 kB/s Bandwidth cap is in effect.\"; }\n"; 
print "else { document.getElementById(\"cappedStatus\").innerHTML = \"NO bandwidth cap is in effect.\"; }\n";
print "document.getElementById(\"clocktime\").innerHTML = json.clocktime;\n";
print "document.getElementById(\"mountaintime\").innerHTML = json.mountaintime;\n";

print "if (json.connection3g == 1) {";
print "document.getElementById(\"connectioninfo\").innerHTML = \"<FONT COLOR='green'><strong>3G cellular connection appears to be up.</strong></FONT>\";\n";
print "if (json.internetstatus == 1) { document.getElementById(\"internetstatus\").innerHTML = \"Using 3G data connection for all internet traffic.\"; }\n";
print "else if (json.internetstatus == 2) { document.getElementById(\"internetstatus\").innerHTML = \"Using WAN data connection for internet traffic.\"; }\n";
print "else { document.getElementById(\"internetstatus\").innerHTML = \"No internet connection found.\"; }\n";
print "document.getElementById(\"connectionmetrics\").innerHTML = json.connectionmetrics;\n ";
print "document.getElementById(\"redialingstatus\").innerHTML = \"\"; ";
print " }\n";
print "else { ";
print "document.getElementById(\"connectioninfo\").innerHTML = \"<FONT COLOR='red'><strong>3G cellular connection appears to be down.</strong></FONT>\" ;";
print "if (json.redialing == 1) { document.getElementById(\"redialingstatus\").innerHTML = \"Redialing in progress.\"; }";
print "else { document.getElementById(\"redialingstatus\").innerHTML = \"Redialing is apparently not in progress...\"; }";
print "if (json.internetstatus == 2) { document.getElementById(\"internetstatus\").innerHTML = \"Using WAN data connection for internet traffic.\"; }\n";
print "else { document.getElementById(\"internetstatus\").innerHTML = \"No internet connection found.\"; }\n";
print "document.getElementById(\"connectionmetrics\").innerHTML = \"\"; ";
print " }"; 

print "});}\n";

print "function submitProvider() {";
$currentprovider = shell_exec("ls -la /etc/config/network | cut -d . -f 2");
print "if (!(\"".trim($currentprovider)."\" == document.preferred.provider.value || document.preferred.provider.value == \"automatic\")) {";
print "alert(\"Changing providers may take several minutes.\\n\\nPlease hit 'OK' then wait until the page fully refreshes.\\n\\nIf the page times out, please refresh the page manually.\");";
print "}";
print "document.preferred.submit();";
print "document.preferred.provider.disabled = true;";
print "}";
print "</script>";
?>

	</body>
</html>
